/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.SscOperation;
import kd.swc.hcss.common.util.BaseResult;

public class FirmCommitOperation
extends SscOperation {
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public FirmCommitOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> beforeOperation(DynamicObject data) {
        return this.validator(data);
    }

    @Override
    public BaseResult<?> validator(DynamicObject billDataArray) {
        String dealStatus = billDataArray.getString("dealstatus");
        if (!"B".equals(dealStatus)) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u529e\u7406\u72b6\u6001\u4e3a\u201c\u5df2\u6838\u5b9a\u6536\u5165\u201d\uff0c\u624d\u80fd\u786e\u8ba4\u63d0\u4ea4\u3002", (String)"FirmCommitOperation_0", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        return BaseResult.tips((String)ResManager.loadKDString((String)"\u786e\u8ba4\u540e\uff0c\u5c06\u65e0\u6cd5\u4fee\u6539\u6536\u5165\u4fe1\u606f\u3002\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FirmCommitOperation_1", (String)"swc-hcss-business", (Object[])new Object[0]));
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        OperationResult result = this.finishCheckApprove(billDataArray);
        if (!result.isSuccess()) {
            return BaseResult.fail((String)((OperateErrorInfo)result.getAllErrorInfo().get(0)).getErrorCode());
        }
        return super.operation(billDataArray, operationKey);
    }

    private OperationResult finishCheckApprove(DynamicObject[] billDataArray) {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        for (DynamicObject billData : billDataArray) {
            Long billId = billData.getLong("id");
            boolean inProcess = WorkflowServiceHelper.inProcess((String)String.valueOf(billId));
            if (!inProcess) continue;
            result = this.incomeProofBillService.consentBillActivity(billData, null);
        }
        return result;
    }
}

