/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.BaseOperationDecorator;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class IssueOperation
extends BaseOperationDecorator {
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public IssueOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> validator(DynamicObject billData) {
        boolean isIssue;
        String dealStatus = billData.getString("dealstatus");
        boolean isUpload = billData.getBoolean("isuploadtpl");
        String issueType = billData.getString("issuetype");
        boolean bl = isIssue = !isUpload && ("I".equals(dealStatus) || "K".equals(dealStatus)) && "0".equals(issueType);
        if (!isIssue) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u529e\u7406\u72b6\u6001\u4e3a\u201c\u5f85\u5f00\u5177\u201d\u6216\u201c\u5df2\u5f00\u5177\u201d\u3001\u5f00\u5177\u5f62\u5f0f\u4e3a\u201c\u7eb8\u8d28\u8bc1\u660e\u201d\u3001\u975e\u4e0a\u4f20\u81ea\u5b9a\u4e49\u6a21\u677f\u7684\u6570\u636e\u624d\u80fd\u6253\u5370\u7eb8\u8d28\u8bc1\u660e\u3002", (String)"IssueOperation_1", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        DynamicObject printTpl = billData.getDynamicObject("printtpl");
        if (printTpl == null) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IssueOperation_2", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        return BaseResult.success(null);
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        this.incomeProofBillService.saveIncomeProofBillIssuedLog(billDataArray);
        return super.operation(billDataArray, operationKey);
    }

    @Override
    public BaseResult<?> afterOperation(AfterDoOperationEventArgs args) {
        return this.afterOperation(args.getOperationResult());
    }

    @Override
    public BaseResult<?> afterOperation(OperationResult operationResult) {
        List successIds = operationResult.getSuccessPkIds();
        if (successIds.isEmpty()) {
            return BaseResult.fail((String)"op fail");
        }
        DynamicObject[] billArray = this.incomeProofBillService.queryIncomeProofBillCol(successIds.stream().map(id -> (Long)id).collect(Collectors.toList()));
        Map<String, List<Object>> printBillMap = this.getPrintBillMap(billArray);
        if (printBillMap.isEmpty()) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"IssueOperation_2", (String)"swc-hcss-business", (Object[])new Object[0]));
        }
        return BaseResult.success(printBillMap);
    }

    private Map<String, List<Object>> getPrintBillMap(DynamicObject[] billArray) {
        HashMap<String, List<Object>> printBillMap = new HashMap<String, List<Object>>(16);
        for (DynamicObject billData : billArray) {
            Long id = billData.getLong("id");
            String printTplId = billData.getString("printtpl.id");
            if (!SWCStringUtils.isNotEmpty((String)printTplId)) continue;
            List billIds = printBillMap.getOrDefault(printTplId, new ArrayList(10));
            billIds.add(id);
            printBillMap.put(printTplId, billIds);
        }
        return printBillMap;
    }
}

