/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.SscOperation;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ReSignOperation
extends SscOperation {
    private static final Log LOGGER = LogFactory.getLog(ReSignOperation.class);
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public ReSignOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> beforeOperation(DynamicObject data, OperateOption option, AbstractFormPlugin plugin) {
        BaseResult<?> baseResult = super.beforeOperation(data, option, plugin);
        if (!baseResult.isSuccess()) {
            return baseResult;
        }
        FormShowParameter parameter = new FormShowParameter();
        if ("hstc".equals(option.getVariableValue("currbizappid", ""))) {
            parameter.setCustomParams(plugin.getView().getFormShowParameter().getCustomParams());
        }
        parameter.setCustomParam("lawentity", (Object)data.getLong("lawentity.id"));
        parameter.setCustomParam("id", Collections.singletonList(data.getLong("id")));
        parameter.setFormId("hcss_dealresign");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hcss_dealresign"));
        return BaseResult.form((FormShowParameter)parameter);
    }

    @Override
    public BaseResult<?> beforeOperation(ListSelectedRowCollection listSelectedData, OperateOption option, AbstractFormPlugin plugin) {
        BaseResult<?> baseResult = super.beforeOperation(listSelectedData, option, plugin);
        if (!baseResult.isSuccess()) {
            return baseResult;
        }
        List idList = listSelectedData.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObjectCollection collection = this.incomeProofBillService.queryIncomeProofBillHandleCol("id,lawentity.id", filter, "");
        Long lawEntityId = 0L;
        for (DynamicObject data2 : collection) {
            Long id = data2.getLong("lawentity.id");
            if (lawEntityId != 0L && !lawEntityId.equals(id)) {
                lawEntityId = 0L;
                break;
            }
            lawEntityId = id;
        }
        FormShowParameter parameter = new FormShowParameter();
        if ("hstc".equals(option.getVariableValue("currbizappid", ""))) {
            parameter.setCustomParams(plugin.getView().getFormShowParameter().getCustomParams());
        }
        parameter.setCustomParam("lawentity", (Object)lawEntityId);
        parameter.setCustomParam("id", idList);
        parameter.setFormId("hcss_dealresign");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "hcss_dealresign"));
        return BaseResult.form((FormShowParameter)parameter);
    }

    @Override
    public BaseResult<?> validator(DynamicObject billData) {
        boolean isResign;
        String issueType = billData.getString("issuetype");
        String dealStatus = billData.getString("dealstatus");
        boolean bl = isResign = "1".equals(issueType) && ("I".equals(dealStatus) || "F".equals(dealStatus));
        if (isResign) {
            return BaseResult.success(null);
        }
        return BaseResult.fail((String)ResManager.loadKDString((String)"\u529e\u7406\u72b6\u6001\u4e3a\u201c\u5f85\u5f00\u5177\u201d\u6216\u201c\u7b7e\u7f72\u5931\u8d25\u201d\u3001\u5f00\u5177\u5f62\u5f0f\u4e3a\u201c\u7535\u5b50\u8bc1\u660e\u201d\u7684\u6570\u636e\u624d\u80fd\u91cd\u65b0\u7b7e\u7f72\u3002", (String)"ReSignOperation_0", (String)"swc-hcss-business", (Object[])new Object[0]));
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey, Map<String, String> variableValues) {
        Long lawEntityId = Long.parseLong(variableValues.getOrDefault("lawentity", "0"));
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        for (DynamicObject billData : billDataArray) {
            this.sign(billData, lawEntityId, errorMap);
        }
        DynamicObject[] dynamicObjectArray = null;
        try (TXHandle txHandle = TX.requiresNew();){
            BaseResult<?> result = super.operation(billDataArray, operationKey);
            if (!result.isSuccess()) {
                BaseResult<?> baseResult = result;
                return baseResult;
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        ArrayList<DynamicObject> signList = new ArrayList<DynamicObject>(billDataArray.length);
        for (DynamicObject billData : billDataArray) {
            boolean isSign = this.signNew(billData, lawEntityId, errorMap);
            if (isSign) continue;
            signList.add(billData);
        }
        BaseResult<?> baseResult = super.operation(signList.toArray(new DynamicObject[0]), operationKey);
        if (errorMap.isEmpty()) {
            return baseResult;
        }
        return BaseResult.failMap(errorMap);
    }

    private void sign(DynamicObject billData, Long lawEntityId, Map<Long, String> errorMap) {
        BaseResult<SignRespParam> baseResult = this.incomeProofBillService.encontractSign(billData, lawEntityId, true);
        if (baseResult.isSuccess()) {
            SignRespParam data = (SignRespParam)baseResult.getData();
            billData.set("econnumber", (Object)data.getContractNo());
            billData.set("lawentity", (Object)lawEntityId);
            billData.set("econtfailreason", (Object)"");
        } else {
            String message = baseResult.getMessage();
            message = message.length() > 200 ? message.substring(0, 200) : message;
            billData.set("econtfailreason", (Object)message);
            billData.set("lawentity", (Object)lawEntityId);
            billData.set("econnumber", (Object)"");
            errorMap.put(billData.getLong("id"), billData.getString("billno") + "\uff1a" + message);
        }
    }

    private boolean signNew(DynamicObject billData, Long lawEntityId, Map<Long, String> errorMap) {
        if (SWCStringUtils.isNotEmpty((String)billData.getString("econnumber"))) {
            BaseResult<SignRespParam> baseResult = this.incomeProofBillService.signNew(billData, lawEntityId);
            if (!baseResult.isSuccess()) {
                String message = baseResult.getMessage();
                message = message.length() > 200 ? message.substring(0, 200) : message;
                billData.set("econtfailreason", (Object)message);
                billData.set("econnumber", (Object)"");
                errorMap.put(billData.getLong("id"), billData.getString("billno") + "\uff1a" + message);
            }
            return baseResult.isSuccess();
        }
        return true;
    }
}

