/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.business.web.income.billop.BaseOperationDecorator;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SignBackOperation
extends BaseOperationDecorator {
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    public SignBackOperation(BaseOperation operation) {
        super(operation);
    }

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey, Map<String, String> variableValues) {
        String isSuccess = variableValues.getOrDefault("issignsuccess", "");
        for (DynamicObject billData : billDataArray) {
            this.dealSign(billData, SWCStringUtils.isNotEmpty((String)isSuccess));
        }
        return super.operation(billDataArray, operationKey);
    }

    private void dealSign(DynamicObject billData, boolean isSuccess) {
        if (isSuccess) {
            BaseResult<SignRespParam> baseResult = this.incomeProofBillService.dealSign(billData);
            if (baseResult.isSuccess()) {
                billData.set("econtfailreason", (Object)"");
            } else {
                String message = baseResult.getMessage();
                message = message.length() > 200 ? message.substring(0, 200) : message;
                billData.set("econtfailreason", (Object)message);
            }
        } else {
            billData.set("econtfailreason", (Object)"signNotify error");
        }
    }
}

