/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcss.business.web.income.billop;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcss.business.service.income.IncomeProofBillService;
import kd.swc.hcss.business.web.income.billop.BaseOperation;
import kd.swc.hcss.common.enums.IncomeProofStatusEnum;
import kd.swc.hcss.common.util.BaseResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class StatusOperation
extends BaseOperation {
    private IncomeProofBillService incomeProofBillService = (IncomeProofBillService)DomainFactory.getInstance(IncomeProofBillService.class);

    @Override
    public BaseResult<?> operation(DynamicObject[] billDataArray, String operationKey) {
        List operationEnumList = IncomeProofStatusEnum.getOperationEnumList((String)operationKey);
        if ("unsubmit".equals(operationKey) || "unsubmitmob".equals(operationKey)) {
            this.incomeProofBillService.sscTaskDeal(billDataArray);
        }
        for (DynamicObject billData : billDataArray) {
            if (operationEnumList.isEmpty()) {
                return BaseResult.success((Object)"statusEnum is null");
            }
            if (operationEnumList.size() == 1) {
                IncomeProofStatusEnum incomeProofStatusEnum = (IncomeProofStatusEnum)operationEnumList.get(0);
                this.incomeProofBillSetStatus(billData, incomeProofStatusEnum);
                continue;
            }
            if ("begincheckapprove".equals(operationKey)) {
                boolean isUpload = billData.getBoolean("isuploadtpl");
                if (isUpload) {
                    this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.BEGIN_CHECK_APPROVE_CUSTOM);
                } else {
                    this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.BEGIN_CHECK_APPROVE);
                }
            }
            if ("autosign".equals(operationKey)) {
                if (SWCStringUtils.isEmpty((String)billData.getString("econtfailreason"))) {
                    this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.AUTO_SIGN_SUCCESS);
                } else {
                    this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.AUTO_SIGN_FAIL);
                }
            }
            if ("resign".equals(operationKey)) {
                if (SWCStringUtils.isEmpty((String)billData.getString("econtfailreason"))) {
                    this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.RE_SIGN_SUCCESS);
                } else {
                    this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.RE_SIGN_FAIL);
                }
            }
            if (!"signsuccess".equals(operationKey)) continue;
            if (SWCStringUtils.isEmpty((String)billData.getString("econtfailreason"))) {
                this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.SIGNBACK_SUCCESS);
                continue;
            }
            this.incomeProofBillSetStatus(billData, IncomeProofStatusEnum.SIGNBACK_FAIL);
        }
        this.incomeProofBillService.saveOrUpdateIncomeBillData(billDataArray);
        return BaseResult.success(null);
    }

    private void incomeProofBillSetStatus(DynamicObject billData, IncomeProofStatusEnum incomeProofStatusEnum) {
        String billStatus = incomeProofStatusEnum.getBillStatus();
        String auditStatus = incomeProofStatusEnum.getAuditStatus();
        String dealStatus = incomeProofStatusEnum.getDealStatus();
        if (!"default_status".equals(billStatus)) {
            billData.set("billstatus", (Object)billStatus);
        }
        if (!"default_status".equals(auditStatus)) {
            billData.set("auditstatus", (Object)auditStatus);
        }
        if (!"default_status".equals(dealStatus)) {
            billData.set("dealstatus", (Object)dealStatus);
        }
    }
}

