/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.mservice;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataSaveHelper;
import kd.swc.hpdi.business.helper.BizDataUpdateHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.mservice.api.IHPDIBizDataService;

public class HPDIBizDataService
implements IHPDIBizDataService {
    private static final Log logger = LogFactory.getLog(HPDIBizDataService.class);
    private static final String SELECT_PROPERTIES = "hpdi_bizdatabillent.entryentity.bizitem";

    public Map<String, Object> getUsedBizItemsFromBizItemGroup(Map<String, Object> params) {
        DynamicObjectCollection bizDataBillQueryResult;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (params == null || params.isEmpty()) {
            return result;
        }
        Object bizItemGroupIdObj = params.get("bizItemGroupId");
        Object bizItemIdsObj = params.get("bizItemIds");
        logger.info("HPDIBizDataService.getUsedBizItemsFromBizItemGroup bizItemGroupId\uff1a{}, toBeQueryBizItemIds: {}", bizItemGroupIdObj, bizItemIdsObj);
        if (!(bizItemGroupIdObj instanceof Long) || (Long)bizItemGroupIdObj == 0L) {
            return result;
        }
        Long bizItemGroupId = (Long)bizItemGroupIdObj;
        QFilter filter = new QFilter("bizitemgroup", "=", (Object)bizItemGroupId);
        filter.and("billstatus", "!=", (Object)"F");
        if (bizItemIdsObj != null) {
            JSONArray bizItemIdsJson;
            try {
                bizItemIdsJson = (JSONArray)bizItemIdsObj;
            }
            catch (Exception exception) {
                return result;
            }
            filter.and(SELECT_PROPERTIES, "in", (Object)bizItemIdsJson.toArray());
        }
        if (CollectionUtils.isEmpty((Collection)(bizDataBillQueryResult = HPDIDataServiceHelper.HPDI_BIZDATABILLQUERY_HELPER.queryOriginalCollection(SELECT_PROPERTIES, new QFilter[]{filter})))) {
            return result;
        }
        HashSet<Long> bizItemIdsUsed = new HashSet<Long>(16);
        for (DynamicObject bizDataBillObj : bizDataBillQueryResult) {
            bizItemIdsUsed.add(bizDataBillObj.getLong(SELECT_PROPERTIES));
        }
        result.put("bizItemGroupId", bizItemGroupIdObj);
        result.put("bizItemIds", bizItemGroupIdObj);
        result.put("bizItemIdsUsed", bizItemIdsUsed);
        return result;
    }

    public Map<String, Object> saveBizData(Map<String, Object> params) {
        BizDataSaveHelper serviceHelper = new BizDataSaveHelper();
        return serviceHelper.saveBizData(params);
    }

    public Map<String, Object> changeDepemp(Map<String, Object> param) {
        BizDataUpdateHelper bizDataHelper = new BizDataUpdateHelper();
        return bizDataHelper.changeDepemp(param);
    }

    public Map<String, Object> updateBizData(List<Map<String, Object>> params) {
        BizDataUpdateHelper bizDataHelper = new BizDataUpdateHelper();
        return bizDataHelper.updateBizData(params);
    }
}

