/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.mservice;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.BizDataTransSalaryStatusHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.mservice.api.IShareService;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ShareService
implements IShareService {
    private static final Log logger = LogFactory.getLog(ShareService.class);

    public Map<String, Object> invokeOperation(String pageId, String opkey, OperateOption operateOption) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        if (formView == null) {
            return Collections.emptyMap();
        }
        OperationResult operationResult = operateOption == null ? formView.invokeOperation(opkey) : formView.invokeOperation(opkey, operateOption);
        List acts = new ArrayList(0);
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        if (clientViewProxy != null) {
            acts = clientViewProxy.getActionResult();
        }
        resultMap.put("operationResult", operationResult);
        resultMap.put("acts", acts);
        return resultMap;
    }

    public Map<String, Object> getButtonViewByActivityId(Map<String, Object> map) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        HashMap showInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            Long activityId = Long.valueOf(String.valueOf(map.get("activityId")));
            String activityNumber = String.valueOf(map.get("activityNumber"));
            if ("hpdi_summaryvbill".equals(activityNumber)) {
                String showFormNum = "hpdi_sumvbillview_ssc";
                showInfoMap.put("showform", showFormNum);
                ArrayList buttonInfos = Lists.newArrayListWithCapacity((int)10);
                showInfoMap.put("buttons", buttonInfos);
                HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
                showInfoMap.put("customParams", customParams);
            }
            rpcResult.put("data", showInfoMap);
            rpcResult.put("success", Boolean.TRUE);
        }
        catch (Exception exception) {
            logger.error("invoke hpdi IHRCSDataPermissionService error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> refreshStatus(Map<String, Object> map) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            List bizDataBillIdList = (List)map.get("listSelectedData");
            BizDataTransSalaryStatusHelper.refreshBizDataBillTransStatus((List)bizDataBillIdList);
            rpcResult.put("msg", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u63a8\u9001\u72b6\u6001\u5df2\u6210\u529f\u5237\u65b0\u3002", (String)"BizDataBillList_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            rpcResult.put("success", Boolean.TRUE);
        }
        catch (Exception exception) {
            logger.error("invoke hpdi refreshStatus error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }

    public Map<String, Object> queryCountDownMap(Map<String, Object> paramsMap) {
        HashMap rpcResult = Maps.newHashMapWithExpectedSize((int)16);
        try {
            List paramsList = (List)rpcResult.get("paramsList");
            Map result = HPDIServiceUtils.queryPayNodeTimes((List)paramsList);
            boolean isSuccess = (Boolean)result.get("success");
            if (!isSuccess) {
                logger.error(MessageFormat.format("BizDataBillList-PayNodeHelper.queryPayNodeTimeBatch() exception:{0}", result.get("message")));
            } else {
                Object dataObj = result.get("data");
                if (dataObj != null) {
                    HashMap<String, String> idAndCountDownMap = new HashMap<String, String>(16);
                    JSONArray data = (JSONArray)result.get("data");
                    for (int j = 0; j < data.size(); ++j) {
                        String returnedId = (String)data.getJSONObject(j).get((Object)"id");
                        Date endTime = (Date)data.getJSONObject(j).get((Object)"endtime");
                        Date startTime = (Date)data.getJSONObject(j).get((Object)"starttime");
                        logger.info(MessageFormat.format("BizDataBillList-result:startTime is {0}, endTime is {1}", startTime, endTime));
                        Date nowDate = new Date();
                        String countDownByTime = BizDataHelper.getCountDownByTime((Date)endTime, (Date)nowDate);
                        if (SWCStringUtils.isEmpty((String)countDownByTime)) continue;
                        idAndCountDownMap.put(returnedId, countDownByTime);
                    }
                    rpcResult.put("data", idAndCountDownMap);
                }
            }
        }
        catch (Exception exception) {
            logger.error("invoke hpdi refreshStatus error", (Throwable)exception);
            rpcResult.put("success", Boolean.FALSE);
        }
        return rpcResult;
    }
}

