/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.mservice.update;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CloudCollaBizAppUpdateService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaBizAppUpdateService.class);
    private static final String QUERY_TRIGGER_COLLA_OBJECT_SQL = "SELECT FENTITYOBJECTID FROM T_HPDI_TRIGGERCOLLA WHERE FENTITYOBJECTID != ' ' AND FENTITYOBJECTID IS NOT NULL";
    private static final String QUERY_OBJECT_BIZAPP_SQL = "SELECT FID,FBIZAPPID FROM T_META_MAINENTITYINFO ";
    private static final String UPDATE_TRIGGER_BIZAPPID_SQL = "UPDATE T_HPDI_TRIGGERCOLLA SET FBIZAPPID = ? WHERE FENTITYOBJECTID = ?;";
    private static final String QUERY_PAY_ROLL_ACT_SQL = "SELECT DISTINCT T.FID,TR.FBIZAPPID FROM T_HPDI_PAYROLLACT T INNER JOIN T_HPDI_PAYROLLACTENT ENT ON T.FID = ENT.FID  INNER JOIN T_HPDI_TRIGGERCOLLA TR ON ENT.FTRIGGERCOLLAID = TR.FID  WHERE ( T.FBIZAPPID = ' ' OR T.FBIZAPPID IS NULL OR T.FBIZAPPID = '') AND (TR.FBIZAPPID != ' ' AND TR.FBIZAPPID IS NOT NULL AND TR.FBIZAPPID != '')";
    private static final String UPDATE_PAYROLLACT_BIZAPPID_SQL = "UPDATE T_HPDI_PAYROLLACT SET FBIZAPPID = ? WHERE FID = ?;";
    private static final String QUERY_PAY_ROLL_ACT_TPL_SQL = "SELECT DISTINCT T.FID,AC.FBIZAPPID FROM T_HPDI_PAYROLLACTGTPL T INNER JOIN T_HPDI_PAYROLLACTGTPLENT ENT ON T.FID = ENT.FID INNER JOIN T_HPDI_PAYROLLACT AC ON ENT.FPAYROLLACTID = AC.FID WHERE ( T.FBIZAPPID = ' ' OR T.FBIZAPPID IS NULL OR T.FBIZAPPID = '') AND (AC.FBIZAPPID != ' ' AND AC.FBIZAPPID IS NOT NULL AND AC.FBIZAPPID != '')";
    private static final String UPDATE_PAYROLLACTTPL_BIZAPPID_SQL = "UPDATE T_HPDI_PAYROLLACTGTPL SET FBIZAPPID = ? WHERE FID = ?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("[CloudCollaBizAppUpdate]: 1. CloudCollaBizAppUpdateService begin");
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        this.execute();
        LOGGER.info("[CloudCollaBizAppUpdate]: 2. CloudCollaBizAppUpdateService end");
        return upgradeResult;
    }

    private void execute() {
        this.hpdiUpdate();
    }

    private void hpdiUpdate() {
        this.triggerCollaUpdate();
        this.payRollActUpdate();
        this.payRollActTplUpdate();
    }

    private void triggerCollaUpdate() {
        HashSet<String> entityObjectList = new HashSet<String>(11);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryTriggerCollaObject", (DBRoute)DBRoute.of((String)"hpdi"), (String)QUERY_TRIGGER_COLLA_OBJECT_SQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                String entityObjectId = row.getString("FENTITYOBJECTID");
                if (SWCStringUtils.isEmpty((String)entityObjectId)) continue;
                entityObjectList.add(entityObjectId);
            }
        }
        if (CollectionUtils.isEmpty(entityObjectList)) {
            return;
        }
        String condition = entityObjectList.stream().map(item -> "'" + item + "'").collect(Collectors.joining(","));
        String queryMetaSQL = "SELECT FID,FBIZAPPID FROM T_META_MAINENTITYINFO WHERE FID IN(  " + condition + " )";
        ArrayList<Object[]> objectBizAppList = new ArrayList<Object[]>();
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"updateObjectMeta", (DBRoute)DBRoute.of((String)"sys.meta"), (String)queryMetaSQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                String fid = row.getString("FID");
                String fBizAppId = row.getString("FBIZAPPID");
                objectBizAppList.add(new Object[]{fBizAppId, fid});
            }
        }
        if (CollectionUtils.isEmpty(objectBizAppList)) {
            return;
        }
        SWCDbUtil.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)UPDATE_TRIGGER_BIZAPPID_SQL, objectBizAppList);
    }

    private void payRollActUpdate() {
        ArrayList<Object[]> objectBizAppList = new ArrayList<Object[]>();
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"updatePayRollAct", (DBRoute)DBRoute.of((String)"hpdi"), (String)QUERY_PAY_ROLL_ACT_SQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long fid = row.getLong("FID");
                String fBizAppId = row.getString("FBIZAPPID");
                objectBizAppList.add(new Object[]{fBizAppId, fid});
            }
        }
        if (CollectionUtils.isEmpty(objectBizAppList)) {
            return;
        }
        SWCDbUtil.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)UPDATE_PAYROLLACT_BIZAPPID_SQL, objectBizAppList);
    }

    private void payRollActTplUpdate() {
        ArrayList<Object[]> objectBizAppList = new ArrayList<Object[]>();
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"updatePayRollActTpl", (DBRoute)DBRoute.of((String)"hpdi"), (String)QUERY_PAY_ROLL_ACT_TPL_SQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long fid = row.getLong("FID");
                String fBizAppId = row.getString("FBIZAPPID");
                objectBizAppList.add(new Object[]{fBizAppId, fid});
            }
        }
        if (CollectionUtils.isEmpty(objectBizAppList)) {
            return;
        }
        SWCDbUtil.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)UPDATE_PAYROLLACTTPL_BIZAPPID_SQL, objectBizAppList);
    }
}

