/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.mservice.update;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class RolePermItemUpgradeService
implements IUpgradeService {
    private static final String EXPORT_BIZDATA = "39LBPGW485E4";
    private static final String EXPORT_BILL = "39LBNHLBFL31";
    private static final Log LOGGER = LogFactory.getLog(RolePermItemUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("RolePermItemUpgradeService begin...");
        this.execute();
        LOGGER.info("RolePermItemUpgradeService end...");
        return null;
    }

    private void execute() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("perm_roleperm");
        QFilter filter = new QFilter("roleperm.entity", "=", (Object)"hpdi_bizdatabill");
        filter.and("roleperm.permitem", "=", (Object)"4730fc9f000004ae");
        Object[] rolePermArr = helper.query("roleid.id", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])rolePermArr)) {
            return;
        }
        int size = rolePermArr.length * 2;
        String[] strIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)size);
        String insertSql = "INSERT INTO t_perm_rolepermdetial(FID,FENTRYID,FROLEID,FPERMITEMID,FBIZAPPID,FENTITYTYPEID) VALUES (?,?,?,?,?,?)";
        ArrayList<Object[]> toSaveRolePerms = new ArrayList<Object[]>(size);
        int index = 0;
        for (Object rolePermDy : rolePermArr) {
            Object[] billPermDataArray = this.initData((DynamicObject)rolePermDy, strIds[index], EXPORT_BILL);
            toSaveRolePerms.add(billPermDataArray);
            Object[] dataPermDataArray = this.initData((DynamicObject)rolePermDy, strIds[++index], EXPORT_BIZDATA);
            toSaveRolePerms.add(dataPermDataArray);
            ++index;
        }
        if (!CollectionUtils.isEmpty(toSaveRolePerms)) {
            LOGGER.info("RolePermItemUpgradeService toSaveRolePerms size: {}", (Object)toSaveRolePerms.size());
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)insertSql, toSaveRolePerms);
        }
    }

    private Object[] initData(DynamicObject rolePermDy, String id, String permItemId) {
        Object[] permDataArray = new Object[]{rolePermDy.get("id"), id, rolePermDy.getString("roleid.id"), permItemId, "0NXW1VOPH+QV", "hpdi_bizdatabill"};
        return permDataArray;
    }
}

