/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.mservice.update;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class SubApiMutiLangUpdateService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(SubApiMutiLangUpdateService.class);
    private static final String QUERY_OUT_SQL = "SELECT T.FDETAILID ,T.FAPIFIELDNAME  FROM  T_HPDI_SUBAPISETOTDETAIL T  LEFT JOIN T_HPDI_SUBAPISETOTDETAIL_L L ON T.FDETAILID = L.FDETAILID AND L.FLOCALEID  = 'zh_CN'  WHERE L.FPKID IS NULL";
    private static final String UPDATE_OUT_SQL = "INSERT INTO T_HPDI_SUBAPISETOTDETAIL_L(FPKID, FDETAILID, FLOCALEID, FAPIFIELDNAME) VALUES(?,?,?,?);";
    private static final String QUERY_IN_SQL = "SELECT T.FDETAILID ,T.FFIELDNAME  FROM  T_HPDI_SUBAPISETINDETAIL T  LEFT JOIN T_HPDI_SUBAPISETINDETAIL_L L ON T.FDETAILID = L.FDETAILID AND L.FLOCALEID  = 'zh_CN'  WHERE L.FPKID IS NULL";
    private static final String UPDATE_IN_SQL = "INSERT INTO T_HPDI_SUBAPISETINDETAIL_L(FPKID, FDETAILID, FLOCALEID, FFIELDNAME) VALUES(?,?,?,?);";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.updateInDetail();
        this.updateOutDetail();
        return super.afterExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
    }

    private void updateInDetail() {
        ArrayList<Object[]> result = new ArrayList<Object[]>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"querySubApiMutiLangOut", (DBRoute)DBRoute.of((String)"hpdi"), (String)QUERY_OUT_SQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long detailId = row.getLong("FDETAILID");
                String apiFieldName = row.getString("FAPIFIELDNAME");
                result.add(new Object[]{null, detailId, "zh_CN", apiFieldName});
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        String[] ids = DB.genStringIds((String)"T_HPDI_SUBAPISETOTDETAIL_L", (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            ((Object[])result.get((int)i))[0] = ids[i];
        }
        SWCDbUtil.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)UPDATE_OUT_SQL, result);
    }

    private void updateOutDetail() {
        ArrayList<Object[]> result = new ArrayList<Object[]>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"querySubApiMutiLangIn", (DBRoute)DBRoute.of((String)"hpdi"), (String)QUERY_IN_SQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long detailId = row.getLong("FDETAILID");
                String apiFieldName = row.getString("FFIELDNAME");
                result.add(new Object[]{null, detailId, "zh_CN", apiFieldName});
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        String[] ids = DB.genStringIds((String)"T_HPDI_SUBAPISETINDETAIL_L", (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            ((Object[])result.get((int)i))[0] = ids[i];
        }
        SWCDbUtil.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)UPDATE_IN_SQL, result);
    }
}

