/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"swc-hpdi-servicehelper", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("IHPDIService", "kd.swc.hpdi.mservice.HPDIService");
        serviceMap.put("BizDataRuleSysDataService", "kd.swc.hpdi.mservice.update.BizDataRuleSysDataService");
        serviceMap.put("PromptUpgradeService", "kd.swc.hpdi.mservice.update.PromptUpgradeService");
        serviceMap.put("CloudCollaBizAppUpdateService", "kd.swc.hpdi.mservice.update.CloudCollaBizAppUpdateService");
        serviceMap.put("SubApiMutiLangUpdateService", "kd.swc.hpdi.mservice.update.SubApiMutiLangUpdateService");
        serviceMap.put("IHPDIBizDataService", "kd.swc.hpdi.mservice.HPDIBizDataService");
        serviceMap.put("IVerifyBillService", "kd.swc.hpdi.mservice.HPDIVerifyBillServiceImpl");
        serviceMap.put("RolePermItemUpgradeService", "kd.swc.hpdi.mservice.update.RolePermItemUpgradeService");
        serviceMap.put("DelOldRolePermItemForBillExportService", "kd.swc.hpdi.mservice.update.DelOldRolePermItemForBillExportService");
        serviceMap.put("IShareService", "kd.swc.hpdi.mservice.ShareService");
        serviceMap.put("IHPDIEmployeeReviseService", "kd.swc.hpdi.mservice.HPDIEmployeeReviseService");
    }
}

