/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.bizdata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.enums.OperateStep;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.AddTransSalaryService;
import kd.swc.hpdi.business.service.UpdateTransSalaryService;
import kd.swc.hpdi.opplugin.HPDIResMgrOpPlugin;
import kd.swc.hpdi.opplugin.validator.bizdata.BizDataCalSalaryValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class BizDataRecordCalSalaryOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new BizDataCalSalaryValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("bizdatacode");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] bizDataRecordArr = args.getDataEntities();
        List bizDataRecordIds = Arrays.stream(bizDataRecordArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("bizdatarecord", "in", bizDataRecordIds);
        DynamicObject[] bizDataArr = bizDataHelper.query("id, bizdatacode, billtype, depemp, bizitemgroup", new QFilter[]{bizDataFilter});
        Map<String, List<DynamicObject>> collect = Arrays.stream(bizDataArr).collect(Collectors.groupingBy(bizData -> bizData.getString("billtype")));
        if (!CollectionUtils.isEmpty((Collection)collect.get("2"))) {
            BizDataHelper.getTransSalaryService(UpdateTransSalaryService.class).transSalary(collect.get("2"), OperateStep.HAND_TRANS_SALARYA.getCode());
        }
        ArrayList bizDataList = Lists.newArrayListWithCapacity((int)10);
        collect.forEach((key, val) -> {
            if (!"2".equals(key)) {
                bizDataList.addAll(val);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)bizDataList)) {
            BizDataHelper.getTransSalaryService(AddTransSalaryService.class).transSalary(collect.get("1"), OperateStep.HAND_TRANS_SALARYA.getCode());
        }
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        this.getOperationResult().setMessage(HPDIResMgrOpPlugin.getMsgOfTransSalaryProcess());
    }
}

