/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.bizdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataRollBackHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataRecordRollbackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("bizdatastatus");
        fieldKeys.add("bizdatacode");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        Map errorMap;
        Object[] bizDataRecordArr = args.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])bizDataRecordArr)) {
            return;
        }
        List bizDataRecordIds = Arrays.stream(bizDataRecordArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        String allCols = SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_bizdata");
        DynamicObject[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query(allCols, new QFilter[]{new QFilter("bizdatarecord", "in", bizDataRecordIds)});
        HashMap param = new HashMap(16);
        Map variables = this.getOption().getVariables();
        if (null != variables) {
            param.put("appNumber", variables.get("currbizappid"));
            param.put("billFormId", variables.get("billFormId"));
        }
        if (!(errorMap = BizDataRollBackHelper.doRollBackForNoCircle(param, (DynamicObject[])bizDataArr, (boolean)true)).isEmpty()) {
            int initialCapacity = bizDataRecordArr.length - errorMap.size();
            initialCapacity = initialCapacity > 0 ? initialCapacity : 10;
            ArrayList<Long> successPkIds = new ArrayList<Long>(initialCapacity);
            for (Object bizDataRecord : bizDataRecordArr) {
                if (errorMap.containsKey(bizDataRecord.getString("bizdatacode"))) continue;
                successPkIds.add(bizDataRecord.getLong("id"));
            }
            this.getOperationResult().setSuccessPkIds(successPkIds);
            for (Map.Entry entry : errorMap.entrySet()) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setErrorCode("rollback_fail");
                errorInfo.setMessage((String)entry.getKey() + "\uff1a" + (String)entry.getValue());
                errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
                this.getOperationResult().getAllErrorInfo().add(errorInfo);
            }
        }
    }
}

