/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.bizdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataRollBackHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataRollbackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("id");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        Object[] waitRollbackData = args.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])waitRollbackData)) {
            return;
        }
        List bizDataIds = Arrays.stream(waitRollbackData).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        String allCols = SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_bizdata");
        DynamicObject[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query(allCols, new QFilter[]{new QFilter("id", "in", bizDataIds)});
        List<DynamicObject> bizDataList = Arrays.asList(bizDataArr);
        String opKey = args.getOperationKey();
        HashMap param = new HashMap(16);
        Map variables = this.getOption().getVariables();
        if (null != variables) {
            param.put("appNumber", variables.get("currbizappid"));
            param.put("billFormId", variables.get("billFormId"));
        }
        Map errorMap = new HashMap(16);
        if ("circlerollback".equals(opKey)) {
            errorMap = BizDataRollBackHelper.doRollBackForCircle(param, (DynamicObject[])bizDataArr);
        } else if ("nocirclerollback".equals(opKey)) {
            errorMap = BizDataRollBackHelper.doRollBackForNoCircle(param, (DynamicObject[])bizDataArr, (boolean)false);
        }
        if (!errorMap.isEmpty()) {
            int initialCapacity = bizDataList.size() - errorMap.size();
            initialCapacity = initialCapacity > 0 ? initialCapacity : 10;
            ArrayList<Long> successBizDataIds = new ArrayList<Long>(initialCapacity);
            HashMap<String, String> codeMap = new HashMap<String, String>(bizDataList.size());
            for (DynamicObject dynamicObject : bizDataList) {
                String bizDataCode;
                String key = bizDataCode = dynamicObject.getString("bizdatacode");
                if ("circlerollback".equals(opKey) && "2".equals(dynamicObject.getString("billtype"))) {
                    key = key + "_" + dynamicObject.getString("id");
                }
                codeMap.put(key, bizDataCode);
                if (errorMap.containsKey(key)) continue;
                successBizDataIds.add(dynamicObject.getLong("id"));
            }
            this.getOperationResult().setSuccessPkIds(successBizDataIds);
            for (Map.Entry entry : errorMap.entrySet()) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setErrorCode("rollback_fail");
                errorInfo.setMessage((String)codeMap.get(entry.getKey()) + "\uff1a" + (String)entry.getValue());
                errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
                this.getOperationResult().getAllErrorInfo().add(errorInfo);
            }
        }
    }
}

