/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.bizdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.enums.OperateStep;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.AddTransSalaryService;
import kd.swc.hpdi.business.service.UpdateTransSalaryService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class FrontBizDataSaveAndEffectOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FrontBizDataSaveAndEffectOp.class);
    private Map<DynamicObject, List<DynamicObject>> objsMap = new HashMap<DynamicObject, List<DynamicObject>>(16);

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
    }

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        List fieldKeys = eventArgs.getFieldKeys();
        BizDataHelper.addFieldKeys((List)fieldKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Object[] bizDataBillArr;
        String isSubmitAndEffectSuccess = this.getOption().getVariableValue("isSubmitAndEffectSuccess", "true");
        if ("false".equals(isSubmitAndEffectSuccess)) {
            ArrayList successObjs = new ArrayList();
            args.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
            return;
        }
        DynamicObject[] dataEntities = args.getDataEntities();
        if (null == dataEntities) {
            return;
        }
        ArrayList<Long> pkIdList = new ArrayList<Long>(dataEntities.length);
        Date currentDate = new Date();
        for (DynamicObject dataEntity : dataEntities) {
            pkIdList.add(dataEntity.getLong("id"));
            dataEntity.set("billstatus", (Object)"C");
            dataEntity.set("auditdate", (Object)currentDate);
        }
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter filter = new QFilter("id", "in", pkIdList);
        for (Object bizDataBillDy : bizDataBillArr = bizDataBillHelper.query("id,billstatus,auditdate", new QFilter[]{filter})) {
            bizDataBillDy.set("billstatus", (Object)"C");
            bizDataBillDy.set("auditdate", (Object)currentDate);
        }
        if (SWCArrayUtils.isEmpty((Object[])bizDataBillArr)) {
            return;
        }
        bizDataBillHelper.update((DynamicObject[])bizDataBillArr);
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            logger.info("FrontBizDataSaveAndEffectOp-endOperationTransaction billNo is:{}", (Object)dataEntity.getString("billno"));
            List objs = BizDataHelper.submissionDo((DynamicObject)dataEntity);
            this.objsMap.put(dataEntity, objs);
            logger.info("FrontBizDataSaveAndEffectOp-endOperationTransaction billNo is:{} objs.size:{}", (Object)dataEntity.getString("billno"), (Object)objs.size());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            List<DynamicObject> objs;
            logger.info("FrontBizDataSaveAndEffectOp-afterExecuteOperationTransaction billNo is:{}", (Object)dataEntity.getString("billno"));
            String tranSalaryMode = dataEntity.getString("bizitemgroup.transalarymode");
            if ("1".equals(tranSalaryMode) || CollectionUtils.isEmpty(objs = this.objsMap.get(dataEntity))) continue;
            logger.info("FrontBizDataSaveAndEffectOp-afterExecuteOperationTransaction billNo is:{} objs.size:{}", (Object)dataEntity.getString("billno"), (Object)objs.size());
            this.transSalary(dataEntity, objs);
        }
    }

    private void transSalary(DynamicObject dataEntity, List<DynamicObject> objs) {
        SWCThreadPoolFactory.getBizdataSyncThreadpool().execute(() -> {
            logger.info("FrontBizDataSaveAndEffectOp-afterExecuteOperationTransaction-transSalary billNo is:{} objs.size:{}", (Object)dataEntity.getString("billno"), (Object)objs.size());
            List objsSplit = BizDataHelper.splitBizData((List)objs);
            for (List objsBatch : objsSplit) {
                try (TXHandle txHandle = TX.requiresNew();){
                    logger.info("FrontBizDataSaveAndEffectOp-afterExecuteOperationTransaction-transSalary-begin billNo is:{} objsBatch.size:{}", (Object)dataEntity.getString("billno"), (Object)objsBatch.size());
                    if ("2".equals(dataEntity.getString("billtype"))) {
                        logger.info("FrontBizDataSaveAndEffectOp threadPool.execute() start");
                        BizDataHelper.getTransSalaryService(UpdateTransSalaryService.class).transSalary(objsBatch, OperateStep.AUTO_TRANS_SALARY.getCode());
                        logger.info("FrontBizDataSaveAndEffectOp (UpdateTransSalaryService.class).transSalary() execution is completed");
                        return;
                    }
                    BizDataHelper.getTransSalaryService(AddTransSalaryService.class).transSalary(objsBatch, OperateStep.AUTO_TRANS_SALARY.getCode());
                    txHandle.commit();
                    logger.info("FrontBizDataSaveAndEffectOp-afterExecuteOperationTransaction-transSalary-end billNo is:{} objsBatch.size:{}", (Object)dataEntity.getString("billno"), (Object)objsBatch.size());
                }
            }
        });
    }
}

