/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.bizdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.common.constants.BizDataBillConstants;
import kd.swc.hpdi.opplugin.validator.bizdata.BizDataBillSaveValidator;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class FrontBizDataSaveOp
extends AbstractOperationServicePlugIn
implements BizDataBillConstants {
    private static Log logger = LogFactory.getLog(FrontBizDataSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        this.configChangedEntryData(eventArgs);
        eventArgs.addValidator((AbstractValidator)new BizDataBillSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        List fieldKeys = eventArgs.getFieldKeys();
        BizDataHelper.addFieldKeys((List)fieldKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        long currTime = System.currentTimeMillis();
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject bizDataBill = dataEntities[0];
        logger.info("BizDataBillSaveValidator...begin...{}...dealBizDataBillEntryEntity", (Object)currTime);
        List<DynamicObject> waitSaveEntrys = this.dealBizDataBillEntryEntity(bizDataBill);
        logger.info("BizDataBillSaveValidator...end.....{}...dealBizDataBillEntryEntity", (Object)currTime);
        logger.info("BizDataBillSaveValidator...begin.....{}...refreshRelationData", (Object)currTime);
        List entryIds = waitSaveEntrys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        BizDataHelper.refreshRelationDataPart((DynamicObject)bizDataBill, entryIds);
        logger.info("BizDataBillSaveValidator...end.......{}...refreshRelationData", (Object)currTime);
    }

    private List<DynamicObject> dealBizDataBillEntryEntity(DynamicObject bizDataBill) {
        if (!bizDataBill.getDataEntityType().getProperties().containsKey((Object)"entryentity")) {
            return new ArrayList<DynamicObject>(10);
        }
        DynamicObjectCollection entryentitys = bizDataBill.getDynamicObjectCollection("entryentity");
        if (null == entryentitys) {
            return new ArrayList<DynamicObject>(10);
        }
        List<Long> entryIds = entryentitys.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList());
        List<Long> waitDeleteEntryIds = this.getWaitDeleteEntryIds();
        entryIds.addAll(waitDeleteEntryIds);
        DynamicObject[] dbEntrys = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.loadDynamicObjectArray((Object[])entryIds.toArray(new Long[0]));
        Map<Long, DynamicObject> dbEntryMap = Arrays.asList(dbEntrys).stream().collect(Collectors.toMap(entry -> entry.getLong("id"), entry -> entry, (k1, k2) -> k2));
        ArrayList<DynamicObject> waitSaveEntrys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> waitDeleteEntrys = new ArrayList<DynamicObject>(10);
        for (DynamicObject entry2 : entryentitys) {
            Long entryId = entry2.getLong("id");
            DynamicObject dbEntry = dbEntryMap.get(entryId);
            dbEntry = BizDataBillEntryHelper.dealEntry((Long)bizDataBill.getLong("id"), (DynamicObject)entry2, (DynamicObject)dbEntry);
            BizDataBillEntryHelper.dealDetail((DynamicObject)entry2, (DynamicObject)dbEntry, (DynamicObject)bizDataBill.getDynamicObject("bizitemgroup"));
            waitSaveEntrys.add(dbEntry);
        }
        for (Long entryId : waitDeleteEntryIds) {
            DynamicObject dbEntry = dbEntryMap.get(entryId);
            if (dbEntry == null) continue;
            waitDeleteEntrys.add(dbEntry);
        }
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("deleteentryids", this.getOption().getVariableValue("deleteentryids", null));
        BizDataBillEntryHelper.invokeOperation((String)"save", (OperateOption)opOption, (DynamicObject[])waitSaveEntrys.toArray(new DynamicObject[0]));
        BizDataBillEntryHelper.invokeOperation((String)"delete", (DynamicObject[])waitDeleteEntrys.toArray(new DynamicObject[0]));
        waitSaveEntrys.addAll(waitDeleteEntrys);
        return waitSaveEntrys;
    }

    private List<Long> getWaitDeleteEntryIds() {
        ArrayList<Long> waitDeleteEntryIds = new ArrayList<Long>(10);
        String deleteentryidsCache = this.getOption().getVariableValue("deleteentryids", null);
        if (deleteentryidsCache != null) {
            String[] deleteentryidsCacheArr;
            for (String id : deleteentryidsCacheArr = deleteentryidsCache.split(",")) {
                waitDeleteEntryIds.add(Long.parseLong(id));
            }
        }
        return waitDeleteEntryIds;
    }

    private void configChangedEntryData(AddValidatorsEventArgs eventArgs) {
        if (null == eventArgs.getDataEntities()) {
            return;
        }
        List<Long> waitDeleteEntryIds = this.getWaitDeleteEntryIds();
        for (DynamicObject dy : eventArgs.getDataEntities()) {
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", dy.getPkValue()));
            Set changedEntryIds = (Set)appCache.get("changed_entry_id_collection", HashSet.class);
            if (CollectionUtils.isEmpty((Collection)changedEntryIds)) continue;
            DynamicObjectCollection dyCollection = new DynamicObjectCollection();
            for (Long entryId : changedEntryIds) {
                if (waitDeleteEntryIds.contains(entryId)) continue;
                DynamicObject row = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(String.valueOf(entryId), String.class)));
                dyCollection.add((Object)row);
            }
            dy.set("entryentity", (Object)dyCollection);
        }
    }
}

