/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskRuleImportValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataList = this.getDataEntities();
        HashSet<Long> createOrgIdSet = new HashSet<Long>(16);
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>(16);
        HashSet<Long> boIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : dataList) {
            this.validateScene(extendedDataEntity);
            this.validateSub(extendedDataEntity);
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            createOrgIdSet.add(dataEntity.getLong("createorg.id"));
            boIdSet.add(dataEntity.getLong("boid"));
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            TaskRuleHelper.getCollaRuleIdByType(idMap, (DynamicObject)dataEntity);
        }
        Map<Long, Set<Long>> payRollActgMap = TaskRuleImportValidator.getPayRollActgMap(createOrgIdSet, idMap);
        Map collaRuleInfoMap = TaskRuleHelper.queryCollaRuleInfo(idMap, (String)"msgsubscriber.id");
        Map<Long, DynamicObject> hisObject = this.getHisObject(boIdSet);
        for (ExtendedDataEntity extendedDataEntity : dataList) {
            this.validateCollaRule(payRollActgMap, hisObject, extendedDataEntity, collaRuleInfoMap);
        }
    }

    private Map<Long, DynamicObject> getHisObject(Set<Long> boIdSet) {
        SWCDataServiceHelper helper;
        DynamicObject[] data;
        if (CollectionUtils.isEmpty(boIdSet)) {
            return Collections.emptyMap();
        }
        String formId = this.getEntityKey();
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = "hpdi_taskrule";
        }
        if ((data = (helper = new SWCDataServiceHelper(formId)).query("id,boid,msgsubscriber.id", new QFilter[]{new QFilter("id", "in", boIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("iscurrentversion", "=", (Object)"1")})) == null || data.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject datum : data) {
            result.put(datum.getLong("id"), datum);
        }
        return result;
    }

    private void validateCollaRule(Map<Long, Set<Long>> payRollActgMap, Map<Long, DynamicObject> hisObject, ExtendedDataEntity extendedDataEntity, Map<String, Map<Long, DynamicObject>> collaRuleInfoMap) {
        DynamicObjectCollection entryEntity;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long msgSubId = dataEntity.getLong("msgsubscriber.id");
        long createOrgId = dataEntity.getLong("createorg.id");
        long boId = dataEntity.getLong("boid");
        DynamicObject hisObj = hisObject.get(boId);
        if (hisObj != null && msgSubId != 0L && hisObj.getLong("msgsubscriber.id") != msgSubId) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u5df2\u5ba1\u6838\u6570\u636e\u7684\u201c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u518d\u8bd5\u3002", (String)"TaskRuleImportValidator_4", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)(entryEntity = dataEntity.getDynamicObjectCollection("entryentity")))) {
            return;
        }
        String tips = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u7b49\u4e8e\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u7684\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u534f\u4f5c\u89c4\u5219\u3002", (String)"TaskRuleImportValidator_6", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        if ("hpdi_taskarrange".equals(this.getEntityKey())) {
            tips = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u7b49\u4e8e\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u7684\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u534f\u4f5c\u89c4\u5219\u3002", (String)"TaskRuleImportValidator_7", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        }
        for (DynamicObject entry : entryEntity) {
            long subId;
            String collaruletype;
            DynamicObject payRollActG = entry.getDynamicObject("collarule");
            if (payRollActG == null) continue;
            long tempId = payRollActG.getLong("id");
            Set orDefault = payRollActgMap.getOrDefault(createOrgId, new HashSet(16));
            if (!orDefault.contains(tempId)) {
                this.addErrorMessage(extendedDataEntity, tips);
            }
            if (StringUtils.isEmpty((CharSequence)(collaruletype = entry.getString("collaruletype")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleImportValidator_5", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<Long, DynamicObject> collaRuleInfos = collaRuleInfoMap.get(collaruletype);
            if (collaRuleInfos == null || collaRuleInfos.get(tempId) == null || msgSubId == (subId = collaRuleInfos.get(tempId).getLong("msgsubscriber.id"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u534f\u4f5c\u89c4\u5219\u4e0e\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u7684\u201c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"TaskRuleImportValidator_3", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateScene(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String bizAppId = dataEntity.getString("scene.bizappid.number");
        if (SWCStringUtils.isEmpty((String)bizAppId)) {
            return;
        }
        if (!"hpdi".equalsIgnoreCase(bizAppId) && !"hsas".equalsIgnoreCase(bizAppId)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u201c\u6240\u5c5e\u5e94\u7528\u201d\u4e3a\u85aa\u8d44\u6570\u636e\u96c6\u6210\u6216\u85aa\u8d44\u6838\u7b97\u7684\u573a\u666f\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u518d\u8bd5\u3002", (String)"TaskRuleImportValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateSub(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String subStatus = dataEntity.getString("msgsubscriber.substatus");
        long subscribeBd = dataEntity.getLong("msgsubscriber.subscribebd.id");
        String enable = dataEntity.getString("msgsubscriber.enable");
        if (!"1".equals(subStatus) || !"1".equals(enable) || 107010L != subscribeBd) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u8ba2\u9605\u65b9\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u201d\uff0c\u4e14\u201c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201d\u7684\u8ba2\u9605\u72b6\u6001\u4e3a\u201c\u5df2\u8ba2\u9605\u201d\u3001\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u518d\u8bd5\u3002", (String)"TaskRuleImportValidator_2", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
        }
    }

    private static Map<Long, Set<Long>> getPayRollActgMap(Set<Long> createOrgIdSet, Map<String, List<Long>> idMap) {
        HashMap<Long, Set<Long>> payRollActgMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<String, List<Long>> entity : idMap.entrySet()) {
            String entityCode = entity.getKey();
            if (StringUtils.isEmpty((CharSequence)entityCode)) continue;
            for (Long orgId : createOrgIdSet) {
                DynamicObjectCollection queryBaseData = BaseDataServiceHelper.queryBaseData((String)entityCode, (Long)orgId, (QFilter)new QFilter("id", "in", entity.getValue()), (String)"id");
                if (CollectionUtils.isEmpty((Collection)queryBaseData)) continue;
                Set tempIdSet = payRollActgMap.computeIfAbsent(orgId, item -> new HashSet(16));
                Set queryIdSet = queryBaseData.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(queryIdSet)) continue;
                tempIdSet.addAll(queryIdSet);
            }
        }
        return payRollActgMap;
    }
}

