/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.validateEnable(dataEntity);
            this.validateVerConf(dataEntity);
        }
    }

    private void validateVerConf(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        if (data == null) {
            return;
        }
        DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        HashSet<String> appNames = new HashSet<String>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            Boolean isManualVerify = dynamicObject.getBoolean("ismanualverify");
            String verifyNumber = dynamicObject.getString("verifynumber");
            String bizAppName = dynamicObject.getString("bizappname");
            if (!isManualVerify.booleanValue() || !SWCStringUtils.isEmpty((String)verifyNumber)) continue;
            appNames.add(bizAppName);
        }
        if (appNames.size() >= 1) {
            StringBuilder sb = new StringBuilder();
            for (String appName : appNames) {
                if (sb.length() > 0) {
                    sb.append("\uff0c");
                }
                sb.append(ResManager.loadKDString((String)"\u201c{0}\u201d", (String)"TaskRuleSaveValidator_7", (String)"swc-hpdi-opplugin", (Object[])new Object[]{appName}));
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u624b\u5de5\u6838\u5b9a\u5e94\u7528{0}\u672a\u6dfb\u52a0\u81f3\u85aa\u916c\u6838\u5b9a\u5355\u4e2d\uff0c\u8bf7\u5728\u201c\u85aa\u916c\u6838\u5b9a\u5355\u8bbe\u7f6e\u201d\u9762\u677f\u4e2d\u8fdb\u884c\u8c03\u6574\u3002", (String)"TaskRuleSaveValidator_5", (String)"swc-hpdi-opplugin", (Object[])new Object[]{sb.toString()}));
        }
    }

    private void validateEnable(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        if (data == null) {
            return;
        }
        DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return;
        }
        String props = "id,name,enable,status,entryentity,entryentity.payrollact,entryentity.payrollact.id,entryentity.payrollact.name";
        Map collaRuleDyMap = TaskRuleHelper.queryCollaRuleInfo((DynamicObjectCollection)entryEntity, (String)props);
        HashSet<Long> set = new HashSet<Long>(16);
        HashSet<Long> set2 = new HashSet<Long>(16);
        long sceneId = data.getLong("scene.id");
        StringBuilder builder = new StringBuilder();
        boolean containsSameAct = Boolean.FALSE;
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection subEntryEntity;
            long collaRuleId = dynamicObject.getLong("collarule.id");
            String name = dynamicObject.getString("collarule.name");
            String type = dynamicObject.getString("collaruletype");
            Map collaRuleMap = (Map)collaRuleDyMap.get(type);
            if (collaRuleMap == null) {
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u201c{0}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleSaveValidator_3", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), name));
                continue;
            }
            DynamicObject collaRuleDyDb = (DynamicObject)collaRuleMap.get(collaRuleId);
            if (collaRuleDyDb == null) {
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u201c{0}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleSaveValidator_3", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), name));
                continue;
            }
            if (!"1".equals(collaRuleDyDb.getString("enable"))) {
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u201c{0}\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleSaveValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), name));
            }
            if (!"C".equals(collaRuleDyDb.getString("status"))) {
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u201c{0}\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleSaveValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), name));
            }
            if (null == (subEntryEntity = collaRuleDyDb.getDynamicObjectCollection("entryentity")) || entryEntity.size() <= 0) continue;
            for (DynamicObject obj : subEntryEntity) {
                Long id = obj.getLong("payrollact.id");
                if (1010L != id && set.contains(id)) {
                    if (!set2.contains(id)) {
                        if (containsSameAct) {
                            builder.append('\u3001');
                        }
                        builder.append('\u201c').append(obj.getString("payrollact.name")).append('\u201d');
                        containsSameAct = Boolean.TRUE;
                    }
                    set2.add(id);
                    continue;
                }
                set.add(id);
            }
        }
        if (containsSameAct) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u8bbe\u7f6e\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u534f\u4f5c\u6d3b\u52a8\u201c{0}\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleSaveValidator_2", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), builder.toString()));
        }
    }
}

