/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;

public class TaskRuleUniqueValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<String, List> uniqueMap = new HashMap<String, List>(16);
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!"C".equalsIgnoreCase(data.getString("status")) && !"audit".equalsIgnoreCase(operateKey)) continue;
            long msgSubscriberId = data.getLong("msgsubscriber.id");
            long orgId = data.getLong("createorg.id");
            String uniqueKey2 = this.getUniqueKey(msgSubscriberId, orgId);
            List extendedDataEntities = uniqueMap.computeIfAbsent(uniqueKey2, item -> new ArrayList(10));
            extendedDataEntities.add(dataEntity);
        }
        if (CollectionUtils.isEmpty(uniqueMap)) {
            return;
        }
        String operationName = this.getOperationName();
        uniqueMap.forEach((uniqueKey, dataEntityList) -> {
            if (dataEntityList.size() <= 1) {
                return;
            }
            String msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf{0}\u521b\u5efa\u7ec4\u7ec7\u548c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u76f8\u540c\u7684\u5df2\u5ba1\u6838\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleUniqueValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[]{operationName});
            if ("audit".equalsIgnoreCase(operateKey)) {
                msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u5ba1\u6838\u521b\u5efa\u7ec4\u7ec7\u548c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u76f8\u540c\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleUniqueValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
            }
            for (ExtendedDataEntity extendedDataEntity : dataEntityList) {
                this.addFatalErrorMessage(extendedDataEntity, msg);
            }
        });
    }

    private String getUniqueKey(long msgSubscriberId, long orgId) {
        if (msgSubscriberId == 0L || orgId == 0L) {
            return "";
        }
        return this.append(String.valueOf(msgSubscriberId), String.valueOf(orgId));
    }

    private String append(String ... data) {
        if (data == null || data.length == 0) {
            return "";
        }
        return Arrays.stream(data).collect(Collectors.joining("#"));
    }
}

