/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.basedate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SubApiSettingMappedFieldKeySaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateField(dataEntity);
        }
    }

    private void validateField(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntities = data.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        HashMap<String, List<Long>> sameObjectData = new HashMap<String, List<Long>>(entryEntities.size());
        HashMap<String, List<Long>> sameFieldData = new HashMap<String, List<Long>>(entryEntities.size());
        HashMap<Long, Set<String>> sameObjectFieldData = new HashMap<Long, Set<String>>(entryEntities.size());
        ArrayList<Long> showInputFieldSource = new ArrayList<Long>(entryEntities.size());
        Map<Long, String> idNameMap = this.processData(entryEntities, sameObjectData, sameFieldData, sameObjectFieldData, showInputFieldSource);
        this.showSameObjectDataError(dataEntity, sameObjectData, idNameMap);
        this.showSameFieldDataError(dataEntity, sameFieldData, idNameMap);
        this.showSameObjectFieldDataError(dataEntity, sameObjectFieldData, idNameMap);
        this.showInputFieldSourceError(dataEntity, showInputFieldSource, idNameMap);
    }

    private void showInputFieldSourceError(ExtendedDataEntity dataEntity, List<Long> showInputFieldSource, Map<Long, String> idNameMap) {
        if (CollectionUtils.isEmpty(showInputFieldSource)) {
            return;
        }
        showInputFieldSource.stream().forEach(apiId -> this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{0}\u201d\u4e2d\u8bf7\u6c42\u53c2\u6570\u7684\u201c\u6765\u6e90\u5b57\u6bb5\u201d\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SubApiSettingMappedFieldKeySaveValidator_2", (String)"swc-hpdi-opplugin", (Object[])new Object[]{idNameMap.get(apiId)})));
    }

    private void showSameObjectFieldDataError(ExtendedDataEntity dataEntity, Map<Long, Set<String>> sameObjectFieldData, Map<Long, String> idNameMap) {
        if (CollectionUtils.isEmpty(sameObjectFieldData)) {
            return;
        }
        sameObjectFieldData.forEach((apiId, fields) -> this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{0}\u201d\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5bf9\u5e94\u5b57\u6bb5\u6807\u8bc6\u201c{1}\u201d\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SubApiSettingMappedFieldKeySaveValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[]{idNameMap.get(apiId), fields.stream().collect(Collectors.joining(","))})));
    }

    private void showSameFieldDataError(ExtendedDataEntity dataEntity, Map<String, List<Long>> sameFieldData, Map<Long, String> idNameMap) {
        if (CollectionUtils.isEmpty(sameFieldData)) {
            return;
        }
        sameFieldData.forEach((fieldNumber, ids) -> {
            if (ids.size() <= 1) {
                return;
            }
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{0}\u201d\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5bf9\u5e94\u5b57\u6bb5\u6807\u8bc6\u201c{1}\u201d\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SubApiSettingMappedFieldKeySaveValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[]{ids.stream().distinct().map(item -> (String)idNameMap.get(item)).collect(Collectors.joining("\u201d\u3001\u201c")), fieldNumber}));
        });
    }

    private void showSameObjectDataError(ExtendedDataEntity dataEntity, Map<String, List<Long>> sameObjectData, Map<Long, String> idNameMap) {
        if (CollectionUtils.isEmpty(sameObjectData)) {
            return;
        }
        sameObjectData.forEach((objectNumber, ids) -> {
            if (ids.size() <= 1) {
                return;
            }
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u4e0d\u5141\u8bb8\u8f6c\u6362\u6210\u540c\u4e00\u4e2a\u4e1a\u52a1\u5bf9\u8c61\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SubApiSettingMappedFieldKeySaveValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[]{ids.stream().map(item -> "\u201c" + (String)idNameMap.get(item) + "\u201d").collect(Collectors.joining("\u3001"))}));
        });
    }

    private Map<Long, String> processData(DynamicObjectCollection entryEntities, Map<String, List<Long>> sameObjectData, Map<String, List<Long>> sameFieldData, Map<Long, Set<String>> sameObjectFieldData, List<Long> showInputFieldSource) {
        HashMap<Long, String> idNameMap = new HashMap<Long, String>(entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            long apiId = entryEntity.getLong("apideploy.id");
            if (apiId == 0L) continue;
            this.processInputFieldSource(entryEntity, showInputFieldSource);
            boolean isConvertObject = entryEntity.getBoolean("isconvertobject");
            String objectNumber = entryEntity.getString("targetobject.number");
            String apiName = entryEntity.getString("apideploy.name");
            idNameMap.put(apiId, apiName);
            if (isConvertObject) {
                List longs = sameObjectData.computeIfAbsent(objectNumber, item -> new ArrayList(10));
                longs.add(apiId);
                DynamicObjectCollection outputSubEntry = entryEntity.getDynamicObjectCollection("outputsubentryentity");
                if (CollectionUtils.isEmpty((Collection)outputSubEntry)) continue;
                HashSet<String> fieldSet = new HashSet<String>(outputSubEntry.size());
                for (DynamicObject dynamicObject : outputSubEntry) {
                    String mapFieldKey = dynamicObject.getString("mapfieldkey");
                    if (fieldSet.add(mapFieldKey)) continue;
                    Set fields = sameObjectFieldData.computeIfAbsent(apiId, item -> new HashSet(16));
                    fields.add(mapFieldKey);
                }
                continue;
            }
            DynamicObjectCollection outputSubEntry = entryEntity.getDynamicObjectCollection("outputsubentryentity");
            if (CollectionUtils.isEmpty((Collection)outputSubEntry)) continue;
            for (DynamicObject dynamicObject : outputSubEntry) {
                String mapFieldKey = dynamicObject.getString("mapfieldkey");
                List longs = sameFieldData.computeIfAbsent(mapFieldKey, item -> new ArrayList(16));
                longs.add(apiId);
            }
        }
        return idNameMap;
    }

    private void processInputFieldSource(DynamicObject entryEntity, List<Long> showInputFieldSource) {
        DynamicObjectCollection inputSubEntry = entryEntity.getDynamicObjectCollection("inputsubentryentity");
        if (CollectionUtils.isEmpty((Collection)inputSubEntry)) {
            return;
        }
        boolean isAllEmtry = true;
        for (DynamicObject dynamicObject : inputSubEntry) {
            String fieldSource = dynamicObject.getString("fieldsource");
            if (SWCStringUtils.isEmpty((String)fieldSource)) continue;
            isAllEmtry = false;
            break;
        }
        if (isAllEmtry) {
            showInputFieldSource.add(entryEntity.getLong("apideploy.id"));
        }
    }
}

