/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.basedate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SubApiSettingSaveValidator
extends AbstractValidator {
    private static final Pattern COMPILE = Pattern.compile("[^\\w\\d_]+|^\\d");

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataObject = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntities = dataObject.getDynamicObjectCollection("entryentity");
            this.validateEntryEntity(dataEntity, entryEntities);
        }
    }

    private void validateEntryEntity(ExtendedDataEntity dataEntity, DynamicObjectCollection entryEntities) {
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        ArrayList<String> apiNameList = new ArrayList<String>(entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            String targetObjectName = this.validateTargetObject(dataEntity, entryEntity);
            if (!SWCStringUtils.isEmpty((String)targetObjectName)) {
                apiNameList.add(targetObjectName);
            }
            this.validateMapFieldKey(dataEntity, entryEntity);
        }
        if (!CollectionUtils.isEmpty(apiNameList)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199API\u53c2\u6570\u914d\u7f6e\u201c{0}\u201d\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u3002", (String)"SubApiSettingSaveValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[]{apiNameList.stream().collect(Collectors.joining("\u201d\u3001\u201c"))}));
        }
    }

    private void validateMapFieldKey(ExtendedDataEntity dataEntity, DynamicObject entryEntity) {
        DynamicObjectCollection outputSubEntryEntity = entryEntity.getDynamicObjectCollection("outputsubentryentity");
        if (CollectionUtils.isEmpty((Collection)outputSubEntryEntity)) {
            return;
        }
        ArrayList<String> outputErrorMsg = new ArrayList<String>(outputSubEntryEntity.size());
        for (int i = 0; i < outputSubEntryEntity.size(); ++i) {
            Matcher matcher;
            DynamicObject dynamicObject = (DynamicObject)outputSubEntryEntity.get(i);
            int seq = dynamicObject.getInt("seq");
            String mapFieldKey = dynamicObject.getString("mapfieldkey");
            if (SWCStringUtils.isEmpty((String)mapFieldKey) || !(matcher = COMPILE.matcher(mapFieldKey)).find()) continue;
            outputErrorMsg.add(String.valueOf(i + 1));
        }
        if (!CollectionUtils.isEmpty(outputErrorMsg)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"API\u53c2\u6570\u914d\u7f6e\u4e2d\u201c{0}\u201d\u7684\u8fd4\u56de\u53c2\u6570\u7684\u7b2c{1}\u884c\u201c\u5bf9\u5e94\u5b57\u6bb5\u6807\u8bc6\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SubApiSettingSaveValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[]{entryEntity.getString("apideploy.name"), outputErrorMsg.stream().collect(Collectors.joining("\u3001"))}));
        }
    }

    private String validateTargetObject(ExtendedDataEntity dataEntity, DynamicObject entryEntity) {
        boolean isConvertObject = entryEntity.getBoolean("isconvertobject");
        if (!isConvertObject) {
            return null;
        }
        DynamicObject targetObject = entryEntity.getDynamicObject("targetobject");
        if (targetObject == null) {
            return entryEntity.getString("apideploy.name");
        }
        return null;
    }
}

