/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.basedate;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterExecuteDataStatusValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        Table<String, Long, DynamicObject> dependency = this.getAllCollaRuleData(extendedDataEntities);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            this.validataCollaRule(extendedDataEntity, dependency);
        }
    }

    private void validataCollaRule(ExtendedDataEntity extendedDataEntity, Table<String, Long, DynamicObject> dependency) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String taskRuleNumber = dataEntity.getString("taskrule.number");
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            DynamicObjectCollection collaRuleEntry;
            long crId = entry.getLong("collarule.id");
            String collaRuleClass = entry.getString("collaruleclass");
            DynamicObject collaRule = (DynamicObject)dependency.get((Object)collaRuleClass, (Object)crId);
            if (collaRule == null) continue;
            String crStatus = collaRule.getString("status");
            boolean crEnable = collaRule.getBoolean("enable");
            if (!"C".equalsIgnoreCase(crStatus) || !crEnable) {
                this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u201c{0}\u201d\u6240\u5f15\u7528\u7684\u534f\u4f5c\u89c4\u5219\u201c{1}\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u6216\u542f\u7528\u540e\u518d\u8bd5\u3002", (String)"TaskCenterExecuteDataStatusValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[]{taskRuleNumber, collaRule.getString("number")}));
            }
            if (CollectionUtils.isEmpty((Collection)(collaRuleEntry = collaRule.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject crEntryRow : collaRuleEntry) {
                DynamicObjectCollection frEntry = crEntryRow.getDynamicObjectCollection("fieldrulesubentryentity");
                if (CollectionUtils.isEmpty((Collection)frEntry)) continue;
                for (DynamicObject frEntryRow : frEntry) {
                    DynamicObject fieldRule = frEntryRow.getDynamicObject("frfieldrule");
                    if (fieldRule == null) continue;
                    String frStatus = fieldRule.getString("status");
                    boolean frEnable = fieldRule.getBoolean("enable");
                    if ("C".equalsIgnoreCase(frStatus) && frEnable) continue;
                    this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u201c{0}\u201d\u6240\u5f15\u7528\u7684\u534f\u4f5c\u89c4\u5219\u201c{1}\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u6216\u542f\u7528\u540e\u518d\u8bd5\u3002", (String)"TaskCenterExecuteDataStatusValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[]{taskRuleNumber, fieldRule.getString("number")}));
                }
            }
        }
    }

    private Table<String, Long, DynamicObject> getAllCollaRuleData(ExtendedDataEntity[] extendedDataEntities) {
        HashMap<String, Set> queryParam = new HashMap<String, Set>(16);
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) continue;
            for (DynamicObject entryEntity : entryEntities) {
                long crId = entryEntity.getLong("collarule.id");
                String crClass = entryEntity.getString("collaruleclass");
                if (crId == 0L || SWCStringUtils.isEmpty((String)crClass)) continue;
                Set ids = queryParam.computeIfAbsent(crClass, item -> new HashSet(16));
                ids.add(crId);
            }
        }
        return HPDICloudCollaHelper.getInstance().queryMultiClassObject(queryParam);
    }
}

