/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.basedate;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterExecuteTaskValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        Map<Long, Map<String, List<DynamicObject>>> dependency = this.getMsgDependencyData(extendedDataEntities);
        Map<Long, Set<DynamicObject>> dependencyBill = this.getDependencyBillData(extendedDataEntities);
        Map<Long, DynamicObject> relBill = this.getRelatedBillList(extendedDataEntities);
        Table<String, Long, Set<Long>> usedCollaRuleTable = this.getUsedCollaRuleTableByOrgId(extendedDataEntities);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject taskCenterObj = extendedDataEntity.getDataEntity();
            this.validateDependencyData(extendedDataEntity, dependency);
            this.validateDependencyBillData(extendedDataEntity, dependencyBill);
            this.validateRelBill(extendedDataEntity, relBill);
            if ("0".equals(taskCenterObj.getString("enable"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u6267\u884c\u3002", (String)"TaskCenterExecuteTaskValidator_2", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection taskDetailMessages = taskCenterObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject taskDetailMessage : taskDetailMessages) {
                if (!"C".equals(taskDetailMessage.getString("taskexecutestatusent"))) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u4e2d\u5b58\u5728\u201c\u6267\u884c\u4e2d\u201d\u7684\u534f\u4f5c\u89c4\u5219\uff0c\u8bf7\u7b49\u5f85\u6267\u884c\u5b8c\u6210\u540e\u518d\u8bd5\u3002", (String)"TaskCenterExecuteTaskValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
            }
            this.validateUsedPayRollActGrp(extendedDataEntity, usedCollaRuleTable);
        }
    }

    private void validateUsedPayRollActGrp(ExtendedDataEntity extendedDataEntity, Table<String, Long, Set<Long>> usedPayRollActGrp) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long orgId = dataEntity.getLong("org.id");
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        String exeStatus = dataEntity.getString("taskexecutestatus");
        if ("D".equalsIgnoreCase(exeStatus)) {
            return;
        }
        HashMap<String, String> className = new HashMap<String, String>(16);
        for (DynamicObject entryEntity : entryEntities) {
            String entryStatus = entryEntity.getString("taskexecutestatusent");
            String crClass = entryEntity.getString("collaruleclass");
            if ("D".equalsIgnoreCase(entryStatus)) continue;
            Set usedIds = (Set)usedPayRollActGrp.get((Object)crClass, (Object)orgId);
            if (usedIds == null) {
                usedIds = Collections.emptySet();
            }
            String collaRuleTypeName = className.computeIfAbsent(crClass, item -> {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)crClass);
                if (dataEntityType == null) {
                    return ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219", (String)"TaskCenterExecuteTaskValidator_8", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
                }
                return dataEntityType.getDisplayName().getLocaleValue();
            });
            Long crId = entryEntity.getLong("collarule.id");
            if (usedIds.contains(crId)) continue;
            this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}\u201c{1}\u201d\u7684\u7ba1\u63a7\u7b56\u7565\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u68c0\u67e5\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u7684\u914d\u7f6e\u3002", (String)"TaskCenterExecuteTaskValidator_7", (String)"swc-hpdi-opplugin", (Object[])new Object[]{collaRuleTypeName, entryEntity.getString("collarule.name")}));
        }
    }

    private Table<String, Long, Set<Long>> getUsedCollaRuleTableByOrgId(ExtendedDataEntity[] extendedDataEntities) {
        HashMap<String, Set> crIdMap = new HashMap<String, Set>(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) continue;
            for (DynamicObject entryEntity : entryEntities) {
                long crId = entryEntity.getLong("collarule.id");
                String crClass = entryEntity.getString("collaruleclass");
                if (crId == 0L || !SWCStringUtils.isNotEmpty((String)crClass)) continue;
                Set tempIds = crIdMap.computeIfAbsent(crClass.toLowerCase(Locale.ROOT), item -> new HashSet(16));
                tempIds.add(crId);
            }
        }
        HashBasedTable result = HashBasedTable.create();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long tempOrgId = extendedDataEntity.getDataEntity().getLong("org.id");
            crIdMap.forEach((arg_0, arg_1) -> TaskCenterExecuteTaskValidator.lambda$getUsedCollaRuleTableByOrgId$3((Table)result, tempOrgId, crIdMap, arg_0, arg_1));
        }
        return result;
    }

    private void validateRelBill(ExtendedDataEntity extendedDataEntity, Map<Long, DynamicObject> relBillMap) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long relBillId = dataEntity.getLong("sumverifybillid");
        DynamicObject relBill = relBillMap.get(relBillId);
        if (relBill == null) {
            return;
        }
        if (!"C".equalsIgnoreCase(relBill.getString("billstatus"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u5b9a\u5355\u201c{0}\u201d\u672a\u5ba1\u6279\u901a\u8fc7\u3002", (String)"TaskCenterExecuteTaskValidator_6", (String)"swc-hpdi-opplugin", (Object[])new Object[]{relBill.getString("billno")}));
        }
    }

    private Map<Long, DynamicObject> getRelatedBillList(ExtendedDataEntity[] extendedDataEntities) {
        if (extendedDataEntities == null || extendedDataEntities.length == 0) {
            return Collections.emptyMap();
        }
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hpdi_summaryvbill");
        Set relBillId = Arrays.stream(extendedDataEntities).map(item -> item.getDataEntity().getLong("sumverifybillid")).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = swcDataServiceHelper.query("id,billstatus,billno", new QFilter[]{new QFilter("id", "in", relBillId)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (first, second) -> first));
    }

    private void validateDependencyBillData(ExtendedDataEntity extendedDataEntity, Map<Long, Set<DynamicObject>> dependencyBill) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long taskId = dataEntity.getLong("id");
        Set<DynamicObject> bills = dependencyBill.get(taskId);
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        for (DynamicObject bill : bills) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}: \u5f53\u524d\u534f\u4f5c\u4efb\u52a1\u4f9d\u8d56\u6d41\u52a8\u7c7b\u578b\u4e3a\u6d41\u51fa\u7684\u85aa\u916c\u6838\u5b9a\u5355\u201c{1}\u201d\uff0c\u8bf7\u5148\u5ba1\u6279\u8be5\u6838\u5b9a\u5355\u3002", (String)"TaskCenterExecuteTaskValidator_5", (String)"swc-hpdi-opplugin", (Object[])new Object[]{dataEntity.getString("number"), bill.getString("billno")}));
        }
    }

    private Map<Long, Set<DynamicObject>> getDependencyBillData(ExtendedDataEntity[] extendedDataEntities) {
        HashMap<String, DynamicObject> msgTaskMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> orgmsgrecvcenterIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObjectCollection verifyapps;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!"1".equals(dataEntity.getString("flowtype")) || 0L == dataEntity.getLong("orgmsgrecvcenter.id") || (verifyapps = dataEntity.getDynamicObjectCollection("collaapp")) == null) continue;
            for (DynamicObject verifyapp : verifyapps) {
                msgTaskMap.put(dataEntity.getString("orgmsgrecvcenter.id") + verifyapp.getString("fbasedataid_id"), dataEntity);
                orgmsgrecvcenterIds.add(dataEntity.getLong("orgmsgrecvcenter.id"));
            }
        }
        SWCDataServiceHelper billOrm = new SWCDataServiceHelper("hpdi_summaryvbill");
        QFilter flowTypeQfilter = new QFilter("flowtype", "=", (Object)"2");
        QFilter enableFilter = new QFilter("billstatus", "not in", (Object)new String[]{"F", "C"});
        QFilter idFilter = new QFilter("orgmsgrecvcenter.id", "in", orgmsgrecvcenterIds);
        DynamicObject[] query = billOrm.query("id,flowtype,billno,billstatus,orgmsgrecvcenter.id,verifyapp", new QFilter[]{flowTypeQfilter, enableFilter, idFilter});
        if (query == null || query.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<DynamicObject>> result = new HashMap<Long, Set<DynamicObject>>(query.length);
        for (DynamicObject bill : query) {
            Long msgId = bill.getLong("orgmsgrecvcenter.id");
            DynamicObjectCollection outApps = bill.getDynamicObjectCollection("verifyapp");
            for (DynamicObject outApp : outApps) {
                Long taskId;
                DynamicObject verifyBill = (DynamicObject)msgTaskMap.get(msgId + outApp.getString("fbasedataid_id"));
                if (verifyBill == null || (taskId = Long.valueOf(verifyBill.getLong("id"))) == null || taskId == 0L) continue;
                Set bills = result.computeIfAbsent(taskId, key -> new HashSet(10));
                bills.add(bill);
            }
        }
        return result;
    }

    private void validateDependencyData(ExtendedDataEntity extendedDataEntity, Map<Long, Map<String, List<DynamicObject>>> dependencyMap) {
        if (CollectionUtils.isEmpty(dependencyMap)) {
            return;
        }
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String flowType = dataEntity.getString("flowtype");
        if (SWCStringUtils.isEmpty((String)flowType) || "0".equalsIgnoreCase(flowType) || "2".equalsIgnoreCase(flowType)) {
            return;
        }
        long msgId = dataEntity.getLong("orgmsgrecvcenter.id");
        Map<String, List<DynamicObject>> appAndTask = dependencyMap.get(msgId);
        if (CollectionUtils.isEmpty(appAndTask)) {
            return;
        }
        DynamicObjectCollection collaApp = dataEntity.getDynamicObjectCollection("collaapp");
        HashSet<String> taskNumberSet = new HashSet<String>(16);
        for (DynamicObject app : collaApp) {
            String appNumber = app.getString("fbasedataid.number");
            List<DynamicObject> preTasks = appAndTask.get(appNumber);
            if (CollectionUtils.isEmpty(preTasks)) continue;
            for (DynamicObject preTask : preTasks) {
                if (!taskNumberSet.add(preTask.getString("number"))) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u534f\u4f5c\u4efb\u52a1\u4f9d\u8d56\u6d41\u52a8\u7c7b\u578b\u4e3a\u6d41\u51fa\u7684\u534f\u4f5c\u4efb\u52a1\u201c{0}\u201d\uff0c\u8bf7\u5148\u6267\u884c\u8be5\u4efb\u52a1\u3002", (String)"TaskCenterExecuteTaskValidator_4", (String)"swc-hpdi-opplugin", (Object[])new Object[]{preTask.getString("number")}));
            }
        }
    }

    private Map<Long, Map<String, List<DynamicObject>>> getMsgDependencyData(ExtendedDataEntity[] extendedDataEntities) {
        if (extendedDataEntities == null || extendedDataEntities.length == 0) {
            return new HashMap<Long, Map<String, List<DynamicObject>>>(0);
        }
        TaskCenterDataHelper taskCenterDataHelper = new TaskCenterDataHelper(extendedDataEntities[0].getDataEntity().getDataEntityType().getName());
        ArrayList<Long> msgRecieveIds = new ArrayList<Long>(10);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            msgRecieveIds.add(dataEntity.getLong("orgmsgrecvcenter.id"));
        }
        if (msgRecieveIds.size() == 0) {
            return Collections.emptyMap();
        }
        DynamicObject[] taskCenters = taskCenterDataHelper.getTaskCenterByMsgReceiveIds(msgRecieveIds);
        if (taskCenters == null || taskCenters.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        for (DynamicObject taskCenter : taskCenters) {
            DynamicObjectCollection collaApps;
            String flowtype;
            Long msgReceiveId = taskCenter.getLong("orgmsgrecvcenter.id");
            String executeStatus = taskCenter.getString("taskexecutestatus");
            if ("D".equals(executeStatus) || !"2".equalsIgnoreCase(flowtype = taskCenter.getString("flowtype")) || (collaApps = taskCenter.getDynamicObjectCollection("collaapp")) == null || collaApps.size() == 0) continue;
            for (DynamicObject app : collaApps) {
                Map typeAndTaskEntry = result.computeIfAbsent(msgReceiveId, key -> Maps.newHashMapWithExpectedSize((int)16));
                List preTaskEntry = typeAndTaskEntry.computeIfAbsent(app.getString("fbasedataid.number"), k -> Lists.newArrayListWithExpectedSize((int)10));
                preTaskEntry.add(taskCenter);
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$getUsedCollaRuleTableByOrgId$3(Table result, long tempOrgId, Map crIdMap, String crClass, Set crIdSet) {
        Set existIds = (Set)result.get((Object)crClass, (Object)tempOrgId);
        if (!CollectionUtils.isEmpty((Collection)existIds)) {
            return;
        }
        DynamicObjectCollection payRollActGrps = BaseDataServiceHelper.queryBaseData((String)crClass, (Long)tempOrgId, (QFilter)new QFilter("id", "in", crIdMap.getOrDefault(crClass, Collections.emptySet())), (String)"id,boid");
        if (CollectionUtils.isEmpty((Collection)payRollActGrps)) {
            return;
        }
        Set idSet = payRollActGrps.stream().map(item -> item.getLong("boid")).collect(Collectors.toSet());
        result.put((Object)crClass, (Object)tempOrgId, idSet);
    }
}

