/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(BizDataBillSaveValidator.class);
    private static final String QUERY_FIELDS = "bizdatabillid,empposorgrel,bizdate,relationdata,currency,calfrequency,effectivedateent,expirydateent,updateexpirydate,updateddesc,remark,dataapprovestatus,approvedesc,bizdatastatus,errormsg,submiterror,bizdatacode,originalbizdatacode,entryentity.bizitem,entryentity.value,entryentity.effectivedate,entryentity.expirydate";

    public void validate() {
        DynamicObjectCollection entryEntities;
        long currTime = System.currentTimeMillis();
        logger.info("BizDataBillSaveValidator...begin...{}", (Object)currTime);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        try {
            entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
        }
        catch (Exception exception) {
            entryEntities = null;
        }
        if (entryEntities != null) {
            if (entryEntities.isEmpty()) {
                return;
            }
            boolean pass = this.validateBeforeConvertData(dataEntities[0]);
            if (!pass) {
                return;
            }
            long billId = dataEntity.getLong("id");
            logger.info("BizDataBillSaveValidator getDataEntities from bill, billNo is {0}", (Object)dataEntity.getString("billno"));
            List<DynamicObject> bizDataEntryEntities = entryEntities.stream().collect(Collectors.toList());
            List<DynamicObject> toEntryEntities = this.convertData(bizDataEntryEntities, billId, dataEntity.getDynamicObject("bizitemgroup"));
            String operateKey = this.getOperateKey();
            OperateOption opOption = OperateOption.create();
            if (SWCStringUtils.equals((String)"save", (String)operateKey)) {
                opOption.setVariableValue("notValidatePeriod", "1");
            }
            opOption.setVariableValue("handletype", dataEntity.getString("handletype"));
            opOption.setVariableValue("deleteentryids", this.getOption().getVariableValue("deleteentryids", null));
            logger.info("BizDataBillSaveValidator...begin...{}...invokeOperation", (Object)currTime);
            BizDataBillEntryHelper.invokeOperation((String)"save_validate", (OperateOption)opOption, (DynamicObject[])toEntryEntities.toArray(new DynamicObject[0]));
            logger.info("BizDataBillSaveValidator...end.....{}...invokeOperation", (Object)currTime);
        } else {
            logger.info("BizDataBillSaveValidator...begin...{}...validateOfList", (Object)currTime);
            logger.info("BizDataBillSaveValidator...end.....{}...validateOfList", (Object)currTime);
        }
        logger.info("BizDataBillSaveValidator...end.....{}", (Object)currTime);
    }

    private List<DynamicObject> convertData(List<DynamicObject> bizDataEntryEntities, long billId, DynamicObject bizItemGroup) {
        ArrayList<DynamicObject> toEntryEntities = new ArrayList<DynamicObject>(bizDataEntryEntities.size());
        for (DynamicObject fromEntry : bizDataEntryEntities) {
            DynamicObject toEntry = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyDynamicObject();
            toEntry = BizDataBillEntryHelper.dealEntry((Long)billId, (DynamicObject)fromEntry, (DynamicObject)toEntry);
            BizDataBillEntryHelper.dealDetail((DynamicObject)fromEntry, (DynamicObject)toEntry, (DynamicObject)bizItemGroup);
            toEntryEntities.add(toEntry);
        }
        return toEntryEntities;
    }

    private boolean validateBeforeConvertData(ExtendedDataEntity extendedDataEntity) {
        boolean isPass = true;
        DynamicObject bizDataBill = extendedDataEntity.getDataEntity();
        if (SWCStringUtils.equals((String)bizDataBill.getString("billtype"), (String)"2")) {
            return isPass;
        }
        boolean isHorizontal = "2".equals(bizDataBill.getString("bizitemgroup.modeltype"));
        String bizItemKeyStr = (String)this.getOption().getVariables().get("bizItemKeys");
        Set currentBizItemKeys = new HashSet(16);
        if (SWCStringUtils.isNotEmpty((String)bizItemKeyStr)) {
            currentBizItemKeys = (Set)SerializationUtils.fromJsonString((String)bizItemKeyStr, Set.class);
        }
        Map bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap((DynamicObject)bizDataBill.getDynamicObject("bizitemgroup"));
        Set effectiveBizItemKeys = bizItemMap.keySet();
        DynamicObjectCollection entryEntities = bizDataBill.getDynamicObjectCollection("entryentity");
        ArrayList<String> errorMsgList = new ArrayList<String>(entryEntities.size());
        for (int i = 0; i < entryEntities.size(); ++i) {
            int rowNum;
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(i);
            String msg = BizDataBillEntryHelper.checkBizItemInvalid((DynamicObject)entryEntity, (int)(rowNum = BizDataBillEntryHelper.getRealRowIndex((Long)bizDataBill.getLong("id"), (Long)entryEntity.getLong("id"), (int)(i + 1))), (boolean)isHorizontal, effectiveBizItemKeys, currentBizItemKeys);
            if (!SWCStringUtils.isNotEmpty((String)msg)) continue;
            if (isHorizontal) {
                this.addErrorMessage(extendedDataEntity, msg);
                return false;
            }
            errorMsgList.add(msg);
            isPass = false;
        }
        if (!isPass) {
            this.addErrorMessage(extendedDataEntity, errorMsgList.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        return isPass;
    }
}

