/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.opplugin.HPDIResMgrOpPlugin;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataBillWFCommValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BizDataBillWFCommValidator.class);

    public void validate() {
        long currTime = System.currentTimeMillis();
        logger.info("BizDataBillWFCommValidator...begin...{}", (Object)currTime);
        this.validatePayNodeTime();
        logger.info("BizDataBillWFCommValidator...end.....{}", (Object)currTime);
    }

    private void validatePayNodeTime() {
        Date currentDate = new Date();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        for (int i = 0; i < dataEntities.length; ++i) {
            boolean isCurrentDateBeforeNodeStartTime;
            String billType;
            ExtendedDataEntity dataEntity = dataEntities[i];
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject bizItemGroup = entity.getDynamicObject("bizitemgroup");
            DynamicObject calPeriod = entity.getDynamicObject("calperiod");
            String handleType = entity.getString("handletype");
            if (SWCObjectUtils.isEmpty((Object)bizItemGroup) || SWCObjectUtils.isEmpty((Object)calPeriod) || SWCObjectUtils.isEmpty((Object)handleType) || "2".equals(billType = entity.getString("billtype")) || !"A".equals(handleType)) continue;
            HashMap parameterMap = Maps.newHashMapWithExpectedSize((int)3);
            parameterMap.put("bizitemgroupid", bizItemGroup.getLong("id"));
            parameterMap.put("periodnumber", calPeriod.getString("number"));
            parameterMap.put("calperiodtype", calPeriod.getLong("periodtypeid"));
            parameterMap.put("org", entity.getLong("bizitemgroup.createorg.id"));
            Map payNodeTime = HPDIServiceUtils.queryPayNodeTime((Map)parameterMap);
            Object endTimeObj = payNodeTime.get("endtime");
            Object startTimeObj = payNodeTime.get("starttime");
            if (endTimeObj == null && startTimeObj == null) {
                return;
            }
            boolean isCurrentDateAfterNodeEndTime = endTimeObj != null && currentDate.after((Date)endTimeObj);
            boolean bl = isCurrentDateBeforeNodeStartTime = startTimeObj != null && currentDate.before((Date)startTimeObj);
            if (!isCurrentDateAfterNodeEndTime && !isCurrentDateBeforeNodeStartTime) continue;
            String msgNoLimit = HPDIResMgrOpPlugin.getMsgOfUnlimited();
            String startTimeStr = startTimeObj == null ? msgNoLimit : SWCInteDateTimeUtil.formatTimeWithSystemZone((Date)((Date)startTimeObj));
            String endTimeStr = endTimeObj == null ? msgNoLimit : SWCInteDateTimeUtil.formatTimeWithSystemZone((Date)((Date)endTimeObj));
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            DynamicObject timeZone = service.getSysTimezone();
            String msg = MessageFormat.format(HPDIResMgrOpPlugin.getMsgOfNotInPayNodeTime(), startTimeStr, endTimeStr, timeZone.getString("number"));
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }
}

