/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.bizdata.filter.BizDataCalPeriodFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataDimFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataFilterChain;
import kd.swc.hpdi.business.bizdata.filter.BizItemConflictFilter;
import kd.swc.hpdi.business.bizdata.filter.BizItemFilter;
import kd.swc.hpdi.business.bizdata.filter.BizItemRepeatFilter;
import kd.swc.hpdi.business.bizdata.filter.EffectiveDateFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDBizDataCodeFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDCommPreDataFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDCyclicItemFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDDataCODImpFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDDataReliabilityFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDExpiryDateFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDItemFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections4.MapUtils;

public class BizDataEntrySaveImportValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(BizDataEntrySaveImportValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList billIds = new ArrayList();
        Map dataEntitiesMap = BizDataBillEntryHelper.convertExtendedDataEntityToMap((ExtendedDataEntity[])dataEntities, billIds);
        Map billDataBillMap = BizDataBillEntryHelper.getBizDataBillInfoByBillIds(billIds);
        for (Map.Entry nextDataEntities : dataEntitiesMap.entrySet()) {
            Long bizDataBillId = (Long)nextDataEntities.getKey();
            List entities = (List)nextDataEntities.getValue();
            DynamicObject bizDataBill = (DynamicObject)billDataBillMap.get(bizDataBillId);
            Map queryMap = BizDataBillEntryHelper.getQueryMap((DynamicObject)bizDataBill);
            this.validateImport(queryMap, entities);
        }
    }

    private void validateImport(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        String billType;
        if (MapUtils.isEmpty(queryMap) || queryMap.get("billtype") == null) {
            return;
        }
        BizDataFilterChain filterChain = new BizDataFilterChain();
        HashMap<String, Map<String, Object>> responses = new HashMap<String, Map<String, Object>>(16);
        switch (billType = (String)queryMap.get("billtype")) {
            case "1": {
                this.validateEntryImportOfAdd(queryMap, filterChain, responses, dataEntities);
                break;
            }
            case "2": {
                this.validateEntryImportOfUpdateExpiryDate(queryMap, filterChain, responses, dataEntities);
                break;
            }
        }
    }

    private void validateEntryImportOfAdd(Map<String, Object> queryMap, BizDataFilterChain filterChain, Map<String, Map<String, Object>> responses, List<ExtendedDataEntity> dataEntities) {
        ArrayList bizDataBillEntries = new ArrayList(dataEntities.size());
        dataEntities.stream().forEach(data -> bizDataBillEntries.add(data.getDataEntity()));
        filterChain.addFilter((IBizDataFilter)new BizItemFilter());
        filterChain.addFilter((IBizDataFilter)new BizDataDimFilter());
        filterChain.addFilter((IBizDataFilter)new EffectiveDateFilter());
        filterChain.addFilter((IBizDataFilter)new BizDataCalPeriodFilter());
        filterChain.addFilter((IBizDataFilter)new BizItemRepeatFilter());
        filterChain.addFilter((IBizDataFilter)new BizItemConflictFilter());
        filterChain.doFilter(queryMap, bizDataBillEntries, (IBizDataFilter)filterChain, responses);
        this.setFatalErrorMessage(dataEntities, responses);
    }

    private void validateEntryImportOfUpdateExpiryDate(Map<String, Object> queryMap, BizDataFilterChain filterChain, Map<String, Map<String, Object>> responses, List<ExtendedDataEntity> dataEntities) {
        ArrayList bizDataBillEntries = new ArrayList(dataEntities.size());
        dataEntities.stream().forEach(data -> bizDataBillEntries.add(data.getDataEntity()));
        filterChain.addFilter((IBizDataFilter)new UEDItemFilter());
        filterChain.addFilter((IBizDataFilter)new UEDCyclicItemFilter());
        filterChain.addFilter((IBizDataFilter)new UEDCommPreDataFilter());
        filterChain.addFilter((IBizDataFilter)new UEDBizDataCodeFilter());
        filterChain.addFilter((IBizDataFilter)new UEDExpiryDateFilter());
        filterChain.addFilter((IBizDataFilter)new UEDDataReliabilityFilter());
        filterChain.addFilter((IBizDataFilter)new UEDDataCODImpFilter());
        filterChain.doFilter(queryMap, bizDataBillEntries, (IBizDataFilter)filterChain, responses);
        this.setFatalErrorMessage(dataEntities, responses);
        this.afterValidate(dataEntities);
    }

    private void afterValidate(List<ExtendedDataEntity> dataEntities) {
        List falseDataEntities = this.getFalseDataEntities();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            if (falseDataEntities.contains(extendedDataEntity)) continue;
            DynamicObject dy = extendedDataEntity.getDataEntity();
            dy.set("bizdatacode", (Object)dy.getString("originalbizdatacode"));
        }
    }

    private void setFatalErrorMessage(List<ExtendedDataEntity> dataEntities, Map<String, Map<String, Object>> responses) {
        if (MapUtils.isEmpty(responses)) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            Object errorMsgObj;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String bizDataCode = dataEntity.getString("bizdatacode");
            Map<String, Object> responseMap = responses.get(bizDataCode);
            if (MapUtils.isEmpty(responseMap) || SWCObjectUtils.isEmpty((Object)(errorMsgObj = responseMap.get("key_result_error_msg"))) || ((String)errorMsgObj).length() < 1) continue;
            this.addFatalErrorMessage(extendedDataEntity, errorMsgObj.toString());
        }
    }
}

