/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataBillEntryCheckingHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.bizdataentryvalidate.BizDataValuePolicyService;
import kd.swc.hpdi.opplugin.HPDIResMgrOpPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataEntrySaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(BizDataEntrySaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList billIds = new ArrayList();
        Map dataEntitiesMap = BizDataBillEntryHelper.convertExtendedDataEntityToMap((ExtendedDataEntity[])dataEntities, billIds);
        Map billDataBillMap = BizDataBillEntryHelper.getBizDataBillInfoByBillIds(billIds);
        boolean containHandleType = this.getOption().containsVariable("handletype");
        for (Map.Entry nextDataEntities : dataEntitiesMap.entrySet()) {
            Long bizDataBillId = (Long)nextDataEntities.getKey();
            List entities = (List)nextDataEntities.getValue();
            DynamicObject bizDataBill = (DynamicObject)billDataBillMap.get(bizDataBillId);
            Map queryMap = BizDataBillEntryHelper.getQueryMap((DynamicObject)bizDataBill);
            queryMap.put("modeltype", bizDataBill.getString("bizitemgroup.modeltype"));
            if (containHandleType) {
                queryMap.put("handletype", this.getOption().getVariableValue("handletype"));
            }
            this.validateSave(queryMap, entities);
        }
    }

    private void validateSave(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        String billType;
        if (org.apache.commons.collections4.MapUtils.isEmpty(queryMap) || queryMap.get("billtype") == null) {
            return;
        }
        switch (billType = (String)queryMap.get("billtype")) {
            case "1": {
                this.validateSaveForAdd(queryMap, dataEntities);
                break;
            }
            case "2": {
                this.validateSaveForUpdate(queryMap, dataEntities);
                break;
            }
        }
    }

    private void validateSaveForAdd(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        boolean isHorizontal = "2".equals(String.valueOf(queryMap.get("modeltype")));
        if (isHorizontal && this.validateEntryNoBizItem(dataEntities)) {
            return;
        }
        this.validateBizDataDim(queryMap, dataEntities);
        this.validateEntryFieldMustInput(queryMap, dataEntities);
        this.validateBizItemEffective(dataEntities);
        this.validateBizItemPerm(queryMap, dataEntities);
        this.validateCurrencyMustInput(dataEntities);
        this.validateEntryValue(queryMap, dataEntities);
        this.validateEntryEffectiveDate(queryMap, dataEntities);
        this.validateCycleItemEffectScopeOfSubmit(dataEntities);
        this.validateCycleItemEffectScopeOfUnSubmit(dataEntities);
        this.checkBizItemMaxInputTime(queryMap, dataEntities);
        if (isHorizontal) {
            this.checkCurrencyNoAmount(dataEntities);
        } else {
            this.checkCurrencyNotAmountItem(dataEntities);
        }
    }

    private void validateSaveForUpdate(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        Object bizItemGroupObj = queryMap.get("bizitemgroup");
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupObj)) {
            return;
        }
        DynamicObject bizItemGroup = (DynamicObject)bizItemGroupObj;
        for (int index = 0; index < dataEntities.size(); ++index) {
            Date bizDate;
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            Date updateExpiryDate = entry.getDate("updateexpirydate");
            if (updateExpiryDate == null) {
                this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u66f4\u65b0\u5931\u6548\u65e5\u671f\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_24", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), index + 1));
            }
            if (!org.apache.commons.collections4.MapUtils.getBoolean(queryMap, (Object)"bizDateMustInput").booleanValue() || !entry.containsProperty("bizdate") || null != (bizDate = entry.getDate("bizdate"))) continue;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u4e1a\u52a1\u5f52\u5c5e\u65e5\u671f\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_06", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), index + 1));
        }
        ArrayList bizDataEntries = new ArrayList(dataEntities.size());
        dataEntities.forEach(data -> bizDataEntries.add(data.getDataEntity()));
        Map responses = BizDataBillEntryCheckingHelper.checkUpdateExpiryDate((DynamicObject)bizItemGroup, bizDataEntries, (String)"2");
        if (!responses.isEmpty()) {
            for (int i = 0; i < dataEntities.size(); ++i) {
                ExtendedDataEntity extendedDataEntity = dataEntities.get(i);
                Object errorMsgObj = this.getErrorMsgObj(responses, extendedDataEntity);
                if (errorMsgObj == null) continue;
                this.addFatalErrorMessage(extendedDataEntity, errorMsgObj.toString());
            }
        }
    }

    private void validateCurrencyMustInput(List<ExtendedDataEntity> dataEntities) {
        block0: for (int index = 0; index < dataEntities.size(); ++index) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObject currency = entry.getDynamicObject("currency");
            if (!SWCObjectUtils.isEmpty((Object)currency)) continue;
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(index + 1));
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : details) {
                long dataTypeId;
                DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
                if (bizItemObj == null || 1020L != (dataTypeId = bizItemObj.getLong("datatype.id"))) continue;
                this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u4e1a\u52a1\u9879\u76ee\u201c{1}\u201d\u4e3a\u91d1\u989d\u7c7b\u578b\uff0c\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"BizDataEntrySaveValidator_45", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), rowIndex, bizItemObj.getString("name")));
                continue block0;
            }
        }
    }

    private void validateEntryFieldMustInput(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        block0: for (int index = 0; index < dataEntities.size(); ++index) {
            Date bizDate;
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(index + 1));
            if (org.apache.commons.collections4.MapUtils.getBoolean(queryMap, (Object)"bizDateMustInput").booleanValue() && entry.containsProperty("bizdate") && null == (bizDate = entry.getDate("bizdate"))) {
                this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u4e1a\u52a1\u5f52\u5c5e\u65e5\u671f\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_06", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), rowIndex));
            }
            boolean entryValidateFail = false;
            for (DynamicObject detail : details) {
                Date effectiveDate;
                String value;
                DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
                    this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u4e1a\u52a1\u9879\u76ee\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_03", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), rowIndex));
                    entryValidateFail = true;
                }
                if (SWCStringUtils.isEmpty((String)(value = detail.getString("value")))) {
                    this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u503c\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_04", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), rowIndex));
                    entryValidateFail = true;
                }
                if ((effectiveDate = detail.getDate("effectivedate")) == null) {
                    this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u751f\u6548\u65e5\u671f\u4e3a\u5fc5\u5f55\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_05", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), rowIndex));
                    entryValidateFail = true;
                }
                if (!entryValidateFail) continue;
                continue block0;
            }
        }
    }

    private void validateEntryValue(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        if (CollectionUtils.isEmpty(dataEntities)) {
            return;
        }
        List bizDataBillEntries = dataEntities.stream().map(entity -> entity.getDataEntity()).collect(Collectors.toList());
        Map bizItemGroupEntMap = BizDataHelper.getBizItemFormBizItemGroup(queryMap, bizDataBillEntries);
        HashSet<Long> dataTypeIds = new HashSet<Long>(16);
        for (int index = 0; index < dataEntities.size(); ++index) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(index + 1));
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : details) {
                long dataTypeId;
                String value = detail.getString("value");
                DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)bizItemObj) || SWCStringUtils.isEmpty((String)value) || dataTypeIds.contains(dataTypeId = bizItemObj.getLong("datatype.id"))) continue;
                dataTypeIds.add(dataTypeId);
                String msg = BizDataValuePolicyService.validate((long)dataTypeId, (Map)bizItemGroupEntMap, (DynamicObject)entry, (int)(rowIndex - 1));
                if (SWCStringUtils.isEmpty((String)msg)) continue;
                this.addFatalErrorMessage(extendedDataEntity, msg);
            }
            dataTypeIds.clear();
        }
    }

    private void validateEntryEffectiveDate(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        if (org.apache.commons.collections4.MapUtils.isEmpty(queryMap) || SWCObjectUtils.isEmpty((Object)queryMap.get("calperiod"))) {
            return;
        }
        DynamicObject calPeriod = (DynamicObject)queryMap.get("calperiod");
        long calPeriodId = calPeriod.getLong("id");
        if (calPeriodId == 0L) {
            this.addFatalErrorMessage(dataEntities.get(0), ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u8bf7\u9a73\u56de\u8865\u5145\u540e\u518d\u63d0\u4ea4\u5ba1\u6279\u3002", (String)"BizDataEntrySaveValidator_21", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
            return;
        }
        Date startDate = calPeriod.getDate("startdate");
        Date endDate = calPeriod.getDate("enddate");
        for (int i = 0; i < dataEntities.size(); ++i) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(i);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            DynamicObject detail = (DynamicObject)details.get(0);
            Date effectiveDate = detail.getDate("effectivedate");
            if (effectiveDate == null) continue;
            boolean cycle = detail.getBoolean("bizitem.cycle");
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(i + 1));
            if (!cycle && startDate.compareTo(effectiveDate) > 0 || effectiveDate.compareTo(endDate) > 0) {
                String errorMsg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u751f\u6548\u65e5\u671f\u9700\u5728\u85aa\u8d44\u671f\u95f4\u5f00\u59cb/\u7ed3\u675f\u65e5\u671f[{1}~{2}]\u8303\u56f4\u5185\u3002", (String)"BizDataEntrySaveValidator_35", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
                if (cycle) {
                    errorMsg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u751f\u6548\u65e5\u671f\u9700\u2264\u85aa\u8d44\u671f\u95f4\u7ed3\u675f\u65e5\u671f{2}\u3002", (String)"BizDataEntrySaveValidator_38", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
                }
                this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, rowIndex, SWCInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"startdate", (Date)startDate), SWCInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"enddate", (Date)endDate)));
                break;
            }
            Date expiryDate = detail.getDate("expirydate");
            if (expiryDate == null || expiryDate.compareTo(effectiveDate) >= 0) continue;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"BizDataEntrySaveValidator_36", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), rowIndex));
            break;
        }
    }

    private void validateCycleItemEffectScopeOfSubmit(List<ExtendedDataEntity> dataEntities) {
        Map<String, DynamicObject> submitBizDataMap = this.getSubmitBizDataMap(dataEntities);
        if (org.apache.commons.collections4.MapUtils.isEmpty(submitBizDataMap)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u9488\u5bf9\u540c\u4e00\u4eba\u5458\u4efb\u804c\u540c\u4e00\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5728\u6700\u65b0\u4e1a\u52a1\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u524d\uff0c\u6216\u751f\u5931\u6548\u65e5\u671f\u4e2d\u95f4\u63d2\u5165\u3002\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7{0}\uff0c\u751f\u6548\u65e5\u671f{1}\u3002", (String)"BizDataEntrySaveValidator_23", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        for (int i = 0; i < dataEntities.size(); ++i) {
            Date bizDataEffectiveDate;
            DynamicObject submitBizData;
            boolean isCycle;
            ExtendedDataEntity extendedDataEntity = dataEntities.get(i);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            DynamicObject detail = (DynamicObject)details.get(0);
            long empPosOrgRelId = entry.getLong("empposorgrel.id");
            long bizItemId = detail.getLong("bizitem.id");
            Date effectiveDate = detail.getDate("effectivedate");
            if (bizItemId == 0L || empPosOrgRelId == 0L || SWCObjectUtils.isEmpty((Object)effectiveDate) || !(isCycle = detail.getBoolean("bizitem.cycle")) || SWCObjectUtils.isEmpty((Object)(submitBizData = submitBizDataMap.get(String.valueOf(empPosOrgRelId) + bizItemId))) || effectiveDate.compareTo(bizDataEffectiveDate = submitBizData.getDate("effectivedate")) > 0) continue;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(msg, submitBizData.getString("bizdatacode"), SWCDateTimeUtils.formatDate((Date)bizDataEffectiveDate)));
        }
    }

    private void validateCycleItemEffectScopeOfUnSubmit(List<ExtendedDataEntity> dataEntities) {
        Map<String, Object> resultMap = this.getCycleItemData(dataEntities);
        Map unSubmitBizDataMap = (Map)resultMap.get("unSubmitBizDataMap");
        Map bizDataBillMap = (Map)resultMap.get("bizDataBillMap");
        if (org.apache.commons.collections4.MapUtils.isEmpty((Map)unSubmitBizDataMap)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u9488\u5bf9\u540c\u4e00\u4eba\u5458\u4efb\u804c\u540c\u4e00\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5728\u6700\u65b0\u4e1a\u52a1\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u524d\uff0c\u6216\u751f\u5931\u6548\u65e5\u671f\u4e2d\u95f4\u63d2\u5165\u3002\u5355\u636e\u7f16\u53f7\uff1a{0}\uff0c\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7{1}\uff0c\u751f\u6548\u65e5\u671f{2}\u3002", (String)"BizDataEntrySaveValidator_22", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject unSubmitBizData;
            boolean isCycle;
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            DynamicObject detail = (DynamicObject)details.get(0);
            long empPosOrgRelId = entry.getLong("empposorgrel.id");
            long bizItemId = detail.getLong("bizitem.id");
            Date effectiveDate = detail.getDate("effectivedate");
            if (bizItemId == 0L || empPosOrgRelId == 0L || SWCObjectUtils.isEmpty((Object)effectiveDate) || !(isCycle = detail.getBoolean("bizitem.cycle")) || (unSubmitBizData = (DynamicObject)unSubmitBizDataMap.get(String.valueOf(empPosOrgRelId) + bizItemId)) == null) continue;
            Date bizDataEffectiveDate = unSubmitBizData.getDate("entryentity.effectivedate");
            Long bizDataBillId = unSubmitBizData.getLong("bizdatabillid");
            if (effectiveDate.compareTo(bizDataEffectiveDate) > 0) continue;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(msg, ((DynamicObject)bizDataBillMap.get(bizDataBillId)).get("billno"), unSubmitBizData.getString("bizdatacode"), SWCDateTimeUtils.formatDate((Date)bizDataEffectiveDate)));
        }
    }

    private Map<String, Object> getCycleItemData(List<ExtendedDataEntity> dataEntities) {
        List cycleEntities = dataEntities.stream().filter(entity -> {
            DynamicObject entry = (DynamicObject)entity.getDataEntity().getDynamicObjectCollection("entryentity").get(0);
            return entry.getBoolean("bizitem.cycle");
        }).collect(Collectors.toList());
        if (SWCListUtils.isEmpty(cycleEntities)) {
            return new HashMap<String, Object>(1);
        }
        Set empposorgRelIds = cycleEntities.stream().map(entity -> entity.getDataEntity().getLong("empposorgrel.id")).collect(Collectors.toSet());
        Set itemIds = cycleEntities.stream().map(entity -> ((DynamicObject)entity.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getLong("bizitem.id")).collect(Collectors.toSet());
        Set bizDataCodes = cycleEntities.stream().map(entity -> entity.getDataEntity().getString("bizdatacode")).collect(Collectors.toSet());
        SWCDataServiceHelper entHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        QFilter eFilter = new QFilter("empposorgrel", "in", empposorgRelIds);
        eFilter.and("entryentity.bizitem", "in", itemIds);
        eFilter.and("entryentity.bizitem.cycle", "=", (Object)"1");
        eFilter.and("bizdatabillid", "!=", (Object)dataEntities.get(0).getDataEntity().getLong("bizdatabillid"));
        DynamicObjectCollection unSubmitedBizDataList = entHelper.queryOriginalCollection("bizdatabillid, empposorgrel.id, bizdatacode, entryentity.bizitem.id, entryentity.effectivedate", eFilter.toArray(), "entryentity.effectivedate desc");
        List unSubmitedBizDataCol = unSubmitedBizDataList.stream().filter(dy -> !bizDataCodes.contains(dy.getString("bizdatacode"))).collect(Collectors.toList());
        Set billIds = unSubmitedBizDataCol.stream().map(entity -> entity.getLong("bizdatabillid")).collect(Collectors.toSet());
        SWCDataServiceHelper billHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter qfilter = new QFilter("billstatus", "not in", (Object)new String[]{"C", "E", "F"});
        qfilter.and("id", "in", billIds);
        DynamicObjectCollection bizDataBills = billHelper.queryOriginalCollection("billno, id", new QFilter[]{qfilter});
        Map<Long, DynamicObject> bizDataBillMap = bizDataBills.stream().collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
        HashMap<String, DynamicObject> unSubmitBizDataMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject bizData : unSubmitedBizDataCol) {
            Long bizDataBillId = bizData.getLong("bizdatabillid");
            String bizKey = bizData.getString("empposorgrel.id") + bizData.getString("entryentity.bizitem.id");
            if (!bizDataBillMap.containsKey(bizDataBillId)) continue;
            unSubmitBizDataMap.putIfAbsent(bizKey, bizData);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("bizDataBillMap", bizDataBillMap);
        resultMap.put("unSubmitBizDataMap", unSubmitBizDataMap);
        return resultMap;
    }

    private Map<String, DynamicObject> getSubmitBizDataMap(List<ExtendedDataEntity> dataEntities) {
        HashMap<String, DynamicObject> submitBizDataMap = new HashMap<String, DynamicObject>(16);
        HashSet empPosOrgRelIds = new HashSet(16);
        HashSet bizItemIds = new HashSet(16);
        HashSet bizDataCodes = new HashSet(16);
        dataEntities.forEach(bizDataEntry -> {
            DynamicObject dataEntity = bizDataEntry.getDataEntity();
            DynamicObjectCollection details = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject detail = (DynamicObject)details.get(0);
            boolean isCycle = detail.getBoolean("bizitem.cycle");
            if (isCycle) {
                bizDataCodes.add(dataEntity.getString("bizdatacode"));
                empPosOrgRelIds.add(dataEntity.getLong("empposorgrel.id"));
                bizItemIds.add(detail.getLong("bizitem.id"));
            }
        });
        if (empPosOrgRelIds.size() == 0) {
            return submitBizDataMap;
        }
        QFilter qFilter = new QFilter("bizdatastatus", "not in", (Object)new String[]{"5", "6", "8"});
        qFilter.and("empposorgrel", "in", empPosOrgRelIds);
        qFilter.and("bizitem", "in", bizItemIds);
        DynamicObjectCollection bizDataColl = BizDataHelper.getBizData((QFilter)qFilter);
        if (bizDataColl.size() == 0) {
            return submitBizDataMap;
        }
        List bizDataList = bizDataColl.stream().filter(dy -> !bizDataCodes.contains(dy.getString("bizdatacode"))).collect(Collectors.toList());
        for (DynamicObject bizData : bizDataList) {
            String empPosOrgRelId = bizData.getString("empposorgrel.id");
            String bizItemId = bizData.getString("bizitem.id");
            submitBizDataMap.putIfAbsent(empPosOrgRelId + bizItemId, bizData);
        }
        return submitBizDataMap;
    }

    private Object getErrorMsgObj(Map<String, Map<String, Object>> responses, ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String originBizDataCode = dataEntity.getString("bizdatacode");
        Map<String, Object> responseMap = responses.get(originBizDataCode);
        if (org.apache.commons.collections4.MapUtils.isEmpty(responseMap)) {
            return null;
        }
        Object errorMsgObj = responseMap.get("key_result_error_msg");
        if (SWCObjectUtils.isEmpty((Object)errorMsgObj) || ((String)errorMsgObj).length() < 1) {
            return null;
        }
        return errorMsgObj;
    }

    private void checkCurrencyNoAmount(List<ExtendedDataEntity> dataEntities) {
        String errorMsg = ResManager.loadKDString((String)"\u201d\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u672a\u586b\u5199\u4efb\u4f55\u91d1\u989d\u9879\u76ee\uff0c\u4e0d\u80fd\u586b\u5199\u5e01\u79cd\u3002", (String)"BizDataEntrySaveValidator_46", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        for (int i = 0; i < dataEntities.size(); ++i) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(i);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObject currency = entry.getDynamicObject("currency");
            if (SWCObjectUtils.isEmpty((Object)currency)) continue;
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(i + 1));
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            boolean notContainAmount = true;
            for (DynamicObject detail : details) {
                long dataTypeId;
                DynamicObject bizItem = detail.getDynamicObject("bizitem");
                if (bizItem == null || 1020L != (dataTypeId = bizItem.getLong("datatype.id"))) continue;
                notContainAmount = false;
                break;
            }
            if (!notContainAmount || SWCObjectUtils.isEmpty((Object)currency)) continue;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, rowIndex));
        }
    }

    private void checkBizItemMaxInputTime(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        DynamicObject bizItemGroup = (DynamicObject)queryMap.get("bizitemgroup");
        String currentBillNo = (String)queryMap.get("billno");
        if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
            return;
        }
        Map<Long, Integer> bizDataMaxInputTimeMap = this.getBizItemMaxInputMap(bizItemGroup, dataEntities);
        if (CollectionUtils.isEmpty(bizDataMaxInputTimeMap)) {
            return;
        }
        HashMap<Long, Set<DynamicObject>> empAndItemMap = new HashMap<Long, Set<DynamicObject>>(16);
        HashBasedTable codeTable = HashBasedTable.create();
        Table<Long, Long, List<DynamicObject>> empAndItemTable = this.getCurrentDataEntityItemMap(dataEntities, currentBillNo, empAndItemMap, (Table<Long, Long, Map<String, Set<String>>>)codeTable);
        if (empAndItemTable.isEmpty()) {
            return;
        }
        HashSet bizItems = new HashSet(16);
        empAndItemMap.forEach((empId, items) -> bizItems.addAll(items));
        List<Long> filterItemList = bizItems.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        Set empPosOrgRelIds = empAndItemTable.rowKeySet();
        DynamicObject calPeriod = (DynamicObject)queryMap.get("calperiod");
        this.addSubmittedDataTable(empAndItemTable, (Table<Long, Long, Map<String, Set<String>>>)codeTable, filterItemList, calPeriod, empPosOrgRelIds);
        HashSet<String> bizDataCodes = new HashSet<String>(dataEntities.size());
        HashMap<Long, ExtendedDataEntity> empEntMap = new HashMap<Long, ExtendedDataEntity>(empPosOrgRelIds.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject ent = dataEntity.getDataEntity();
            bizDataCodes.add(ent.getString("bizdatacode"));
            empEntMap.put(ent.getLong("empposorgrel.id"), dataEntity);
        }
        this.addUnSubmittedDataTable(empAndItemTable, (Table<Long, Long, Map<String, Set<String>>>)codeTable, filterItemList, calPeriod, empPosOrgRelIds, bizDataCodes);
        String notFoundItemMsg = ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u4e1a\u52a1\u9879\u76ee\u201c{0}\u201d\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u3002", (String)"BizDataEntrySaveValidator_33", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        String exceedMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u201c{0}\u201d\u5728\u4e1a\u52a1\u9879\u76ee\u201c{1}\u201d\u7684\u8f93\u5165\u6b21\u6570\u201c{2}\u201d\u8d85\u8fc7\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u8f93\u5165\u6b21\u6570\u201c{3}\u201d\u3002", (String)"BizDataEntrySaveValidator_28", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        String bizDataCodeMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7\uff1a{0}", (String)"BizDataEntrySaveValidator_30", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        String billNoMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\uff1a\u201c{0}\u201d\u3002", (String)"BizDataEntrySaveValidator_31", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        for (Long empPosOrgRelId : empPosOrgRelIds) {
            for (DynamicObject bizItem : (Set)empAndItemMap.get(empPosOrgRelId)) {
                Long bizItemId = bizItem.getLong("id");
                if (null == bizDataMaxInputTimeMap.get(bizItemId)) {
                    this.addFatalErrorMessage((ExtendedDataEntity)empEntMap.get(empPosOrgRelId), MessageFormat.format(notFoundItemMsg, bizItem.getString("name")));
                    continue;
                }
                int maxInputTime = bizDataMaxInputTimeMap.get(bizItemId);
                List bizDataList = (List)empAndItemTable.get((Object)empPosOrgRelId, (Object)bizItemId);
                if (bizDataList.size() == 0 || bizDataList.size() <= maxInputTime) continue;
                Map codeMap = (Map)codeTable.get((Object)empPosOrgRelId, (Object)bizItemId);
                String str1 = MessageFormat.format(exceedMsg, ((ExtendedDataEntity)empEntMap.get(empPosOrgRelId)).getDataEntity().getString("empposorgrel.person.name"), bizItem.getString("name"), bizDataList.size(), maxInputTime);
                String str2 = MessageFormat.format(bizDataCodeMsg, ((Set)codeMap.getOrDefault("bizDataCodes", new HashSet())).toString());
                String str3 = MessageFormat.format(billNoMsg, ((Set)codeMap.getOrDefault("billNos", new HashSet())).toString());
                StringBuilder builder = new StringBuilder();
                builder.append(str1);
                builder.append('\n');
                builder.append(str2);
                builder.append('\n');
                builder.append(str3);
                this.addFatalErrorMessage((ExtendedDataEntity)empEntMap.get(empPosOrgRelId), builder.toString());
            }
        }
    }

    private Table<Long, Long, List<DynamicObject>> getCurrentDataEntityItemMap(List<ExtendedDataEntity> dataEntities, String billNo, Map<Long, Set<DynamicObject>> empAndItemMap, Table<Long, Long, Map<String, Set<String>>> codeTable) {
        ArrayList<DynamicObject> bizItemList = null;
        HashBasedTable table = HashBasedTable.create();
        for (ExtendedDataEntity extEnt : dataEntities) {
            DynamicObject obj = extEnt.getDataEntity();
            Long empPosorgRelId = obj.getDynamicObject("empposorgrel").getLong("id");
            Set bizItems = empAndItemMap.getOrDefault(empPosorgRelId, new HashSet(16));
            for (DynamicObject detail : obj.getDynamicObjectCollection("entryentity")) {
                Long bizItemId = detail.getLong("bizitem.id");
                Boolean isCycle = detail.getBoolean("bizitem.cycle");
                if (SWCObjectUtils.isEmpty((Object)bizItemId) || bizItemId == 0L || isCycle.booleanValue()) continue;
                bizItemList = (ArrayList<DynamicObject>)table.get((Object)empPosorgRelId, (Object)bizItemId);
                if (bizItemList == null) {
                    bizItemList = new ArrayList<DynamicObject>();
                }
                bizItemList.add(detail);
                table.put((Object)empPosorgRelId, (Object)bizItemId, bizItemList);
                bizItems.add(detail.getDynamicObject("bizitem"));
                this.recordRelationCodes(codeTable, empPosorgRelId, bizItemId, billNo, obj.getString("bizdatacode"));
            }
            empAndItemMap.put(empPosorgRelId, bizItems);
        }
        return table;
    }

    private List<Long> getWaitDeleteEntryIds() {
        ArrayList<Long> waitDeleteEntryIds = new ArrayList<Long>(10);
        String deleteentryidsCache = this.getOption().getVariableValue("deleteentryids", null);
        if (deleteentryidsCache != null) {
            String[] deleteentryidsCacheArr;
            for (String id : deleteentryidsCacheArr = deleteentryidsCache.split(",")) {
                waitDeleteEntryIds.add(Long.parseLong(id));
            }
        }
        return waitDeleteEntryIds;
    }

    private boolean validateEntryNoBizItem(List<ExtendedDataEntity> dataEntities) {
        boolean containEntryNoItem = false;
        String errorMsg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u4e1a\u52a1\u9879\u76ee\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"BizDataEntrySaveValidator_29", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        for (int i = 0; i < dataEntities.size(); ++i) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(i);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(i + 1));
            DynamicObjectCollection details = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)details)) continue;
            containEntryNoItem = true;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, rowIndex));
        }
        return containEntryNoItem;
    }

    private Map<Long, Integer> getBizItemMaxInputMap(DynamicObject bizItemGroup, List<ExtendedDataEntity> dataEntities) {
        HashMap<Long, Integer> bizDataMaxInputTimeMap;
        block4: {
            bizDataMaxInputTimeMap = new HashMap<Long, Integer>(16);
            Map bizItemGroupMap = BizDataHelper.getBizItemGroupMapById((DynamicObject)bizItemGroup);
            if (bizItemGroupMap == null || !MapUtils.getBoolean((Map)bizItemGroupMap, (Object)"success").booleanValue()) break block4;
            List resultList = (List)bizItemGroupMap.get("result");
            if (!CollectionUtils.isEmpty((Collection)resultList)) {
                for (Map bizItemMap : resultList) {
                    List itemList = (List)bizItemMap.get("bizitem");
                    itemList.stream().filter(item -> org.apache.commons.collections4.MapUtils.getBoolean((Map)item, (Object)"cycle") == false).forEach(item -> {
                        Long bizItemId = MapUtils.getLong((Map)item, (Object)"bizitemid");
                        bizDataMaxInputTimeMap.put(bizItemId, MapUtils.getInteger((Map)item, (Object)"maxinputtime"));
                    });
                }
            } else {
                String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5ba1\u6838\u540e\u518d\u5904\u7406\u3002", (String)"BizDataEntrySaveValidator_32", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.addFatalErrorMessage(dataEntity, errorMsg);
                }
            }
        }
        return bizDataMaxInputTimeMap;
    }

    private void addSubmittedDataTable(Table<Long, Long, List<DynamicObject>> empAndItemTable, Table<Long, Long, Map<String, Set<String>>> codeTable, List<Long> filterItemList, DynamicObject calPeriod, Set<Long> empPosorgRelIds) {
        DynamicObjectCollection bizDataColl = BizDataHelper.getBizData(filterItemList, (DynamicObject)calPeriod, empPosorgRelIds);
        for (DynamicObject bizDataObj : bizDataColl) {
            Long bizItemId;
            Boolean cycle = bizDataObj.getBoolean("bizitem.cycle");
            if (cycle.booleanValue()) continue;
            Long empPosorgRelId = bizDataObj.getLong("empposorgrel.id");
            ArrayList<DynamicObject> bizDataList = (ArrayList<DynamicObject>)empAndItemTable.get((Object)empPosorgRelId, (Object)(bizItemId = Long.valueOf(bizDataObj.getLong("bizitem.id"))));
            if (bizDataList == null) {
                bizDataList = new ArrayList<DynamicObject>(10);
            }
            bizDataList.add(bizDataObj);
            empAndItemTable.put((Object)empPosorgRelId, (Object)bizItemId, bizDataList);
            this.recordRelationCodes(codeTable, empPosorgRelId, bizItemId, bizDataObj.getString("applyno"), bizDataObj.getString("bizdatacode"));
        }
    }

    private void addUnSubmittedDataTable(Table<Long, Long, List<DynamicObject>> empAndItemTable, Table<Long, Long, Map<String, Set<String>>> codeTable, List<Long> filterItemList, DynamicObject calPeriod, Set<Long> empPosorgRelIds, Set<String> bizDataCodes) {
        Map resultMap = BizDataHelper.getUnSubmitBizData(filterItemList, (DynamicObject)calPeriod, empPosorgRelIds, bizDataCodes);
        List bizDataColl = (List)resultMap.get("bizDataColl");
        if (CollectionUtils.isEmpty((Collection)bizDataColl)) {
            return;
        }
        for (DynamicObject bizData : bizDataColl) {
            DynamicObject billDy;
            Long bizItemId;
            Boolean cycle = bizData.getBoolean("entryentity.bizitem.cycle");
            if (cycle.booleanValue()) continue;
            Long empPosOrgRelId = bizData.getLong("empposorgrel.id");
            ArrayList<DynamicObject> bizDataList = (ArrayList<DynamicObject>)empAndItemTable.get((Object)empPosOrgRelId, (Object)(bizItemId = Long.valueOf(bizData.getLong("entryentity.bizitem.id"))));
            if (null == bizDataList) {
                bizDataList = new ArrayList<DynamicObject>(10);
            }
            bizDataList.add(bizData);
            empAndItemTable.put((Object)empPosOrgRelId, (Object)bizItemId, bizDataList);
            Map billNoMap = (Map)resultMap.get("billNoMap");
            if (null == billNoMap || null == (billDy = (DynamicObject)billNoMap.get(bizData.getLong("bizdatabillid")))) continue;
            this.recordRelationCodes(codeTable, empPosOrgRelId, bizItemId, billDy.getString("billno"), bizData.getString("bizdatacode"));
        }
    }

    private void recordRelationCodes(Table<Long, Long, Map<String, Set<String>>> codeTable, Long empPosorgRelId, Long bizItemId, String billNo, String bizDataCode) {
        HashMap map = (HashMap)codeTable.get((Object)empPosorgRelId, (Object)bizItemId);
        if (null == map) {
            map = new HashMap(16);
        }
        Set bizDataCodes = map.getOrDefault("bizDataCodes", new HashSet(16));
        bizDataCodes.add(bizDataCode);
        map.put("bizDataCodes", bizDataCodes);
        Set billNos = map.getOrDefault("billNos", new HashSet(16));
        billNos.add(billNo);
        map.put("billNos", billNos);
        codeTable.put((Object)empPosorgRelId, (Object)bizItemId, map);
    }

    private void validateBizItemEffective(List<ExtendedDataEntity> dataEntities) {
        block0: for (int index = 0; index < dataEntities.size(); ++index) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(index + 1));
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : details) {
                DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
                if (bizItemObj == null || "1".equals(bizItemObj.getString("enable")) && "C".equals(bizItemObj.getString("status"))) continue;
                this.addFatalErrorMessage(extendedDataEntity, HPDIResMgrOpPlugin.getMsgOfBizItemNotValid(rowIndex, bizItemObj.getString("name")));
                continue block0;
            }
        }
    }

    private void checkCurrencyNotAmountItem(List<ExtendedDataEntity> dataEntities) {
        String errorMsg = ResManager.loadKDString((String)"\u201d\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u975e\u91d1\u989d\u7c7b\u578b\u9879\u76ee\uff0c\u4e0d\u80fd\u586b\u5199\u5e01\u79cd\u3002", (String)"BizDataEntrySaveValidator_47", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
        for (int index = 0; index < dataEntities.size(); ++index) {
            long dataTypeId;
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            DynamicObject currency = entry.getDynamicObject("currency");
            if (SWCObjectUtils.isEmpty((Object)currency)) continue;
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(index + 1));
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            DynamicObject bizItem = ((DynamicObject)details.get(0)).getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItem) || 1020L == (dataTypeId = bizItem.getLong("datatype.id"))) continue;
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, rowIndex));
        }
    }

    private void validateBizDataDim(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        DynamicObject bizDataObjRule = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup((DynamicObject)((DynamicObject)queryMap.get("bizitemgroup")));
        String matchRule = bizDataObjRule.getString("matchrule");
        if ("1".equals(matchRule)) {
            return;
        }
        List currentDimIds = dataEntities.stream().filter(entry -> !SWCObjectUtils.isEmpty((Object)entry.getDataEntity().getDynamicObject("bizdatadim"))).map(entry -> entry.getDataEntity().getLong("bizdatadim.id")).collect(Collectors.toList());
        List bizDataDims = BizDataHelper.getBizDataDimByIds(currentDimIds);
        Map<Long, DynamicObject> dimMap = bizDataDims.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47150e89000000ac");
        for (int index = 0; index < dataEntities.size(); ++index) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry2 = extendedDataEntity.getDataEntity();
            DynamicObject bizDataDim = entry2.getDynamicObject("bizdatadim");
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry2.getLong("bizdatabillid"), (Long)entry2.getLong("id"), (int)(index + 1));
            if (SWCObjectUtils.isEmpty((Object)bizDataDim)) {
                this.addFatalErrorMessage(extendedDataEntity, HPDIResMgrOpPlugin.getMsgOfBizDataDimMustInput(rowIndex));
                continue;
            }
            DynamicObject bizDataDimInDB = dimMap.get(bizDataDim.getLong("id"));
            if (SWCObjectUtils.isEmpty((Object)bizDataDimInDB) || !"C".equals(bizDataDimInDB.getString("status")) || !"1".equals(bizDataDimInDB.getString("enable"))) {
                this.addFatalErrorMessage(extendedDataEntity, HPDIResMgrOpPlugin.getMsgOfBizDataDimInValid(rowIndex, bizDataDim.getString("name")));
                continue;
            }
            if (null == bizDataDimIds || bizDataDimIds.contains(bizDataDim.getLong("id"))) continue;
            this.addFatalErrorMessage(extendedDataEntity, HPDIResMgrOpPlugin.getMsgOfBizDataDimNoPerm(rowIndex, bizDataDim.getString("name")));
        }
    }

    private void validateBizItemPerm(Map<String, Object> queryMap, List<ExtendedDataEntity> dataEntities) {
        if (CollectionUtils.isEmpty(dataEntities)) {
            return;
        }
        Long orgId = (Long)queryMap.get("org");
        List bizDataBillEntries = dataEntities.stream().map(entity -> entity.getDataEntity()).collect(Collectors.toList());
        Map bizItemObjFromItemGroupMap = BizDataHelper.getBizItemFormBizItemGroup(queryMap, bizDataBillEntries);
        Set hasPermBizItemIds = BizDataHelper.getBizItemIdsHasPerm((Long)((Long)queryMap.get("org")), bizItemObjFromItemGroupMap.keySet());
        for (int index = 0; index < dataEntities.size(); ++index) {
            ExtendedDataEntity extendedDataEntity = dataEntities.get(index);
            DynamicObject entry = extendedDataEntity.getDataEntity();
            int rowIndex = BizDataBillEntryHelper.getRealRowIndex((Long)entry.getLong("bizdatabillid"), (Long)entry.getLong("id"), (int)(index + 1));
            DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : details) {
                DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
                if (bizItemObj == null || hasPermBizItemIds.contains(bizItemObj.getLong("id"))) continue;
                this.addFatalErrorMessage(extendedDataEntity, HPDIResMgrOpPlugin.getMsgOfBizItemNoPerm(rowIndex, bizItemObj.getString("name")));
            }
        }
    }
}

