/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataRelationHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataSaveItemRepeatValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BizDataSaveItemRepeatValidator.class);
    private static final String[] EXCLUDE_BILL_STATUS_ARR = new String[]{"C", "E", "F"};

    public void validate() {
        long currTime = System.currentTimeMillis();
        logger.info("BizDataSaveItemRepeatValidator...begin...{}", (Object)currTime);
        this.validateBizItemRepeat();
        logger.info("BizDataSaveItemRepeatValidator...end.....{}", (Object)currTime);
    }

    private void validateBizItemRepeat() {
        Object[] dataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Map<Long, DynamicObject> bizItemObjFromItemGroupMap = this.getBizItemFormBizItemGroup(dataEntities[0].getDataEntity().getLong("bizitemgroup.id"));
        if (bizItemObjFromItemGroupMap.isEmpty()) {
            return;
        }
        Set<Long> empRelIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("empposorgrel.id")).collect(Collectors.toSet());
        Set<Long> itemIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("bizitem.id")).collect(Collectors.toSet());
        Set calperiodIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("calperiod.id")).collect(Collectors.toSet());
        Set bizDataCodes = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getString("bizdatacode")).collect(Collectors.toSet());
        Map<String, Object> unSubmitBizDataResult = this.getUnSubmitBizData(empRelIds, itemIds);
        Map unSubmitBizDataMap = (Map)unSubmitBizDataResult.get("unSubmitBizDataMap");
        Map unSubmitBizDataBillMap = (Map)unSubmitBizDataResult.get("unSubmitBizDataBillMap");
        Map submitBizDataMap = BizDataRelationHelper.getSubmitBizData(empRelIds, itemIds, calperiodIds, bizDataCodes, (boolean)true);
        HashMap<String, Integer> itemBatchNumMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < dataEntities.length; ++i) {
            String msg;
            Object dataEntity = dataEntities[i];
            DynamicObject bizDataDy = dataEntity.getDataEntity();
            Long empPosId = bizDataDy.getLong("empposorgrel.id");
            Long bizitemId = bizDataDy.getLong("bizitem.id");
            if (empPosId == null || bizitemId == null) continue;
            String key = String.valueOf(empPosId) + bizitemId;
            Integer itemNum = (Integer)itemBatchNumMap.get(key);
            if (itemNum == null) {
                itemNum = 1;
            } else {
                Integer n = itemNum;
                Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
            }
            itemBatchNumMap.put(key, itemNum);
            DynamicObject bizItemObjFromItemGroup = bizItemObjFromItemGroupMap.get(bizitemId);
            if (bizItemObjFromItemGroup == null) continue;
            boolean isCycle = bizItemObjFromItemGroup.getBoolean("bizitem.cycle");
            boolean isMultiInput = bizItemObjFromItemGroup.getBoolean("bizitem.multipleinput");
            List unSubmitItems = (List)unSubmitBizDataMap.get(key);
            List submitItems = (List)submitBizDataMap.get(key);
            HashMap<String, Object> responseMap = new HashMap<String, Object>(4);
            if (isCycle) {
                this.validateCycle(bizDataDy, responseMap, unSubmitItems, submitItems);
            }
            if ((msg = (String)responseMap.get("key_result_error_msg")) == null) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
        }
    }

    private void validateCycle(DynamicObject bizDataDy, Map<String, Object> responseMap, List<DynamicObject> unSubmitItems, List<DynamicObject> submitItems) {
        Map<String, Object> newItemMap = this.getNewItem(bizDataDy, unSubmitItems, submitItems);
        if (newItemMap == null || newItemMap.isEmpty()) {
            return;
        }
        Date effectDate = bizDataDy.getDate("effectivedate");
        Date expiryDate = bizDataDy.getDate("expirydate");
        Date newEffectDate = (Date)newItemMap.get("effectivedate");
        Date newExpiryDate = (Date)newItemMap.get("expirydate");
        if (effectDate.compareTo(newEffectDate) <= 0) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_4205.getCode());
        }
        if (effectDate.compareTo(newEffectDate) > 0 && (newExpiryDate == null && expiryDate != null || newExpiryDate != null && expiryDate != null && expiryDate.before(newExpiryDate))) {
            logger.info("excelEffectDate_after_transSalaryDate_and_contain");
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_4205.getCode());
        }
    }

    private Map<String, Object> getNewItem(DynamicObject bizDataDy, List<DynamicObject> unSubmitItems, List<DynamicObject> submitItems) {
        HashMap<String, Object> newItemMap = new HashMap<String, Object>(4);
        DynamicObject unSubmitNewItem = null;
        DynamicObject submitNewItem = null;
        if (unSubmitItems != null && unSubmitItems.size() >= 1) {
            unSubmitNewItem = unSubmitItems.get(0);
        }
        if (submitItems != null && submitItems.size() >= 1) {
            submitNewItem = submitItems.get(0);
        }
        if (unSubmitNewItem != null && submitNewItem == null) {
            this.getEffectiveDateForUnSubmit(newItemMap, unSubmitNewItem, bizDataDy);
        }
        if (unSubmitNewItem == null && submitNewItem != null) {
            this.getEffectiveDateForSubmit(newItemMap, submitNewItem);
        }
        if (unSubmitNewItem != null && submitNewItem != null) {
            DynamicObject bizDataEntItem = this.getBizDataEntItem(unSubmitNewItem, bizDataDy.getLong("bizitem.id"));
            if (bizDataEntItem != null && bizDataEntItem.getDate("effectivedate").compareTo(submitNewItem.getDate("effectivedate")) > 0) {
                this.getEffectiveDateForUnSubmit(newItemMap, unSubmitNewItem, bizDataDy);
            } else {
                this.getEffectiveDateForSubmit(newItemMap, submitNewItem);
            }
        }
        return newItemMap;
    }

    private void getEffectiveDateForSubmit(Map<String, Object> newItemMap, DynamicObject submitNewItem) {
        newItemMap.put("bizdatacode", submitNewItem.get("bizdatacode"));
        newItemMap.put("effectivedate", submitNewItem.get("effectivedate"));
        newItemMap.put("expirydate", submitNewItem.get("expirydate"));
    }

    private void getEffectiveDateForUnSubmit(Map<String, Object> newItemMap, DynamicObject unSubmitNewItem, DynamicObject bizDataDy) {
        DynamicObject bizDataEntItem = this.getBizDataEntItem(unSubmitNewItem, bizDataDy.getLong("bizitem.id"));
        if (bizDataEntItem != null) {
            newItemMap.put("bizdatacode", unSubmitNewItem.get("bizdatacode"));
            newItemMap.put("effectivedate", bizDataEntItem.get("effectivedate"));
            newItemMap.put("expirydate", bizDataEntItem.get("expirydate"));
        }
    }

    private DynamicObject getBizDataEntItem(DynamicObject bizDataEnt, Long bizItemId) {
        DynamicObjectCollection bizDataDetails = bizDataEnt.getDynamicObjectCollection("entryentity");
        for (DynamicObject bizDataDetail : bizDataDetails) {
            Long bizItemIdTmp = bizDataDetail.getLong("bizitem.id");
            if (bizItemIdTmp.compareTo(bizItemId) != 0) continue;
            return bizDataDetail;
        }
        return null;
    }

    private Map<String, Object> getUnSubmitBizData(Set<Long> empRelIds, Set<Long> itemIds) {
        DynamicObject[] bizDataEnts = this.getBizDataEnts(empRelIds, itemIds);
        DynamicObject[] bizDataBillsFromDB = this.getUnSubmitBizDataBills(bizDataEnts);
        Map<Long, DynamicObject> unSubmitBizDataBillMap = Arrays.asList(bizDataBillsFromDB).stream().collect(Collectors.toMap(bu -> bu.getLong("id"), bu -> bu, (k1, k2) -> k1));
        List unSubmitbillIds = Arrays.asList(bizDataBillsFromDB).stream().map(field -> field.getLong("id")).collect(Collectors.toList());
        HashMap<String, List<DynamicObject>> unSubmitBizDataMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject bizDataEnt : bizDataEnts) {
            if (!unSubmitbillIds.contains(bizDataEnt.getLong("bizdatabillid"))) continue;
            String empPosId = bizDataEnt.getString("empposorgrel.id");
            DynamicObjectCollection bizDataDetails = bizDataEnt.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizDataDetail : bizDataDetails) {
                String bizitemId = bizDataDetail.getString("bizitem.id");
                String empItemKey = empPosId + bizitemId;
                this.putValueToListValueMap(unSubmitBizDataMap, bizDataEnt, empItemKey);
            }
        }
        HashMap<String, Object> unSubmitBizDataResult = new HashMap<String, Object>(2);
        unSubmitBizDataResult.put("unSubmitBizDataMap", unSubmitBizDataMap);
        unSubmitBizDataResult.put("unSubmitBizDataBillMap", unSubmitBizDataBillMap);
        return unSubmitBizDataResult;
    }

    private void putValueToListValueMap(Map<String, List<DynamicObject>> map, DynamicObject value, String mKey) {
        List<DynamicObject> valueList = map.get(mKey);
        if (valueList == null) {
            valueList = new ArrayList<DynamicObject>(10);
            map.put(mKey, valueList);
        }
        valueList.add(value);
    }

    private DynamicObject[] getUnSubmitBizDataBills(DynamicObject[] bizDataEnts) {
        Set billIds = Arrays.asList(bizDataEnts).stream().map(field -> field.getLong("bizdatabillid")).collect(Collectors.toSet());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("billstatus", "!=", (Object)"F"));
        qFilters.add(new QFilter("billstatus", "not in", (Object)EXCLUDE_BILL_STATUS_ARR));
        qFilters.add(new QFilter("billtype", "=", (Object)"1"));
        qFilters.add(new QFilter("id", "in", billIds));
        DynamicObject[] bizDataBillsFromDB = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.query("billno,calperiod,entryentity.bizitem,entryentity.effectivedate,entryentity.expirydate,entryentity.empposorgrel,entryentity.bizdatacode", qFilters.toArray(new QFilter[qFilters.size()]));
        return bizDataBillsFromDB;
    }

    private DynamicObject[] getBizDataEnts(Set<Long> empRelIds, Set<Long> itemIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("empposorgrel", "in", empRelIds));
        qFilters.add(new QFilter("entryentity.bizitem", "in", itemIds));
        return HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_bizdatabillent"), qFilters.toArray(new QFilter[qFilters.size()]), "entryentity.effectivedate desc");
    }

    private Map<Long, DynamicObject> getBizItemFormBizItemGroup(Long bizItemGrpId) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> bizItemGrpIdList = new ArrayList<Long>(1);
        bizItemGrpIdList.add(bizItemGrpId);
        DynamicObject[] itemGroupList = null;
        try {
            itemGroupList = HPDIServiceUtils.getBizItemGroupById(bizItemGrpIdList);
        }
        catch (Exception exception) {
            logger.error(MessageFormat.format("BizDataHelper-getBizItemFormBizItemGroup getBizItemGroupById Exception:", exception));
        }
        if (itemGroupList == null || itemGroupList.length == 0) {
            return result;
        }
        DynamicObject queryBizItemGroup = itemGroupList[0];
        DynamicObjectCollection bizItems = queryBizItemGroup.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)bizItems)) {
            return result;
        }
        Map<Long, DynamicObject> bizItemMap = bizItems.stream().collect(Collectors.toMap(bu -> bu.getLong("bizitem.id"), bu -> bu, (k1, k2) -> k1));
        return bizItemMap;
    }

    protected void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        String returnErrorCode = this.getOption().getVariableValue("return_error_code", "false");
        if (!"true".equals(returnErrorCode)) {
            String desc = BizDataFailStatusEnum.getDesc((String)content);
            if (desc == null) {
                desc = content;
            }
            super.addErrorMessage(dataEntity, desc);
        } else {
            super.addErrorMessage(dataEntity, content);
        }
    }
}

