/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BizDataSaveValidator.class);

    public void validate() {
        long currTime = System.currentTimeMillis();
        logger.info("BizDataBillSaveValidator...begin...{}", (Object)currTime);
        this.validateEffectiveDate();
        this.validateBizDataCode();
        this.validateBizDataCalPeriod();
        logger.info("BizDataBillSaveValidator...end.....{}", (Object)currTime);
    }

    private void validateBizDataCalPeriod() {
        Object[] dataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            Object dataEntity = dataEntities[i];
            DynamicObject bizDataDy = dataEntity.getDataEntity();
            Date startDate = bizDataDy.getDate("calperiod.startdate");
            Date endDate = bizDataDy.getDate("calperiod.enddate");
            Date effectiveDate = bizDataDy.getDate("effectivedate");
            if (effectiveDate == null) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, BizDataFailStatusEnum.FAILSTATUS_4005.getCode());
                continue;
            }
            if (startDate == null || endDate == null) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, BizDataFailStatusEnum.FAILSTATUS_4202.getCode());
                continue;
            }
            if (!effectiveDate.before(startDate) && !effectiveDate.after(endDate)) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntity, BizDataFailStatusEnum.FAILSTATUS_4202.getCode());
        }
    }

    private void validateBizDataCode() {
        Object[] dataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Set bizDataCodes = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getString("bizdatacode")).collect(Collectors.toSet());
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hpdi_bizdata");
        QFilter filter = new QFilter("bizdatacode", "in", bizDataCodes);
        DynamicObject[] bizDatas = bizDataHelper.query("bizdatacode", new QFilter[]{filter});
        Set bizDataCodesDB = Arrays.stream(bizDatas).map(dataEntity -> dataEntity.getString("bizdatacode")).collect(Collectors.toSet());
        SWCDataServiceHelper bizBillDataHelper = new SWCDataServiceHelper("hpdi_bizdatabillent");
        QFilter billFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        DynamicObject[] bizDatasBill = bizBillDataHelper.query("bizdatacode", new QFilter[]{billFilter});
        Set bizDatasBillDB = Arrays.stream(bizDatasBill).map(dataEntity -> dataEntity.getString("bizdatacode")).collect(Collectors.toSet());
        HashSet<String> existsSet = new HashSet<String>(16);
        for (int i = 0; i < dataEntities.length; ++i) {
            Object dataEntity2 = dataEntities[i];
            DynamicObject bizDataDy = dataEntity2.getDataEntity();
            String bizDataCode = bizDataDy.getString("bizdatacode");
            if (SWCStringUtils.isEmpty((String)bizDataCode)) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity2, BizDataFailStatusEnum.FAILSTATUS_4007.getCode());
                continue;
            }
            if (existsSet.contains(bizDataCode)) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity2, BizDataFailStatusEnum.FAILSTATUS_1010.getCode());
                continue;
            }
            existsSet.add(bizDataCode);
            if (bizDataCodesDB.contains(bizDataCode)) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity2, BizDataFailStatusEnum.FAILSTATUS_1010.getCode());
                continue;
            }
            if (!bizDatasBillDB.contains(bizDataCode)) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntity2, BizDataFailStatusEnum.FAILSTATUS_1010.getCode());
        }
    }

    private void validateEffectiveDate() {
        Object[] dataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            Object dataEntity = dataEntities[i];
            DynamicObject bizDataDy = dataEntity.getDataEntity();
            Date effectiveDate = bizDataDy.getDate("effectivedate");
            Date expiryDate = bizDataDy.getDate("expirydate");
            if (SWCObjectUtils.isEmpty((Object)expiryDate) || SWCObjectUtils.isEmpty((Object)effectiveDate) || !effectiveDate.after(expiryDate)) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntity, BizDataFailStatusEnum.FAILSTATUS_4201.getCode());
        }
    }

    protected void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        String returnErrorCode = this.getOption().getVariableValue("return_error_code", "false");
        if (!"true".equals(returnErrorCode)) {
            String desc = BizDataFailStatusEnum.getDesc((String)content);
            if (desc == null) {
                desc = content;
            }
            super.addErrorMessage(dataEntity, desc);
        } else {
            super.addErrorMessage(dataEntity, content);
        }
    }
}

