/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.bizdata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataSaveValueValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BizDataSaveValueValidator.class);

    public void validate() {
        long currTime = System.currentTimeMillis();
        logger.info("BizDataSaveValueValidator...begin...{}", (Object)currTime);
        this.validateBizItem();
        logger.info("BizDataSaveValueValidator...end.....{}", (Object)currTime);
    }

    private void validateBizItem() {
        Object[] dataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Map<Long, DynamicObject> bizItemObjFromItemGroupMap = this.getBizItemFormBizItemGroup(dataEntities[0].getDataEntity().getLong("bizitemgroup.id"));
        DynamicObject[] bizItemObjArrayFromDB = this.getBizItemObj((ExtendedDataEntity[])dataEntities);
        Map<Long, DynamicObject> bizItemObjMap = Arrays.asList(bizItemObjArrayFromDB).stream().collect(Collectors.toMap(bu -> bu.getLong("id"), bu -> bu, (k1, k2) -> k1));
        String msg = null;
        for (int i = 0; i < dataEntities.length; ++i) {
            Object dataEntity = dataEntities[i];
            DynamicObject bizDataDy = dataEntity.getDataEntity();
            String value = bizDataDy.getString("value");
            if (SWCStringUtils.isEmpty((String)value)) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, "value is not null");
                continue;
            }
            HashMap<String, Object> responseMap = new HashMap<String, Object>(4);
            DynamicObject currencyDy = bizDataDy.getDynamicObject("currency");
            this.validateIsExistsAmountItemForCurrency(currencyDy, bizDataDy, bizItemObjMap, responseMap);
            msg = (String)responseMap.get("key_result_error_msg");
            if (msg != null) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                continue;
            }
            long bizItemId = bizDataDy.getLong("bizitem.id");
            DynamicObject bizItemObjFromDB = bizItemObjMap.get(bizItemId);
            if (bizItemObjFromDB == null) continue;
            DynamicObject bizItemObjFromItemGroup = bizItemObjFromItemGroupMap.get(bizItemId);
            if (SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
                logger.info("bizItemObjFromItemGroup item_not_exits");
                this.addErrorMessage((ExtendedDataEntity)dataEntity, BizDataFailStatusEnum.FAILSTATUS_4203.getCode());
                continue;
            }
            if ("1".equals(bizItemObjFromItemGroup.getString("bizitem.enable")) && "C".equals(bizItemObjFromItemGroup.getString("bizitem.status"))) {
                this.validateCurrency(currencyDy, responseMap, bizItemObjFromDB);
                msg = (String)responseMap.get("key_result_error_msg");
                if (msg != null) {
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                    continue;
                }
                this.validateValue(bizItemObjFromItemGroup, bizDataDy, responseMap, bizItemObjFromDB, currencyDy);
                msg = (String)responseMap.get("key_result_error_msg");
                if (msg == null) continue;
                this.addErrorMessage((ExtendedDataEntity)dataEntity, msg);
                continue;
            }
            this.addErrorMessage((ExtendedDataEntity)dataEntity, BizDataFailStatusEnum.FAILSTATUS_4204.getCode());
        }
    }

    private void validateValue(DynamicObject bizItemObjFromItemGroup, DynamicObject bizDataDy, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB, DynamicObject currencyObj) {
        if (!responseMap.isEmpty() || SWCStringUtils.isEmpty((String)bizDataDy.getString("value")) || SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
            return;
        }
        List<String> numberTypesList = Arrays.asList(DataGradeValueTypeEnum.AMOUNT.getCode(), DataGradeValueTypeEnum.DECIMAL.getCode(), DataGradeValueTypeEnum.INTEGER.getCode());
        List<String> notMoneyTypeList = Arrays.asList(DataGradeValueTypeEnum.DECIMAL.getCode(), DataGradeValueTypeEnum.INTEGER.getCode());
        if (bizItemObjFromDB == null || bizItemObjFromDB.getString("datatype.number") == null) {
            return;
        }
        String dataType = bizItemObjFromDB.getString("datatype.number");
        if (numberTypesList.contains(dataType)) {
            BigDecimal value = this.parseValueToDecimal(bizDataDy, responseMap);
            if (value == null) {
                return;
            }
            if (notMoneyTypeList.contains(dataType) && this.validateMaxMin(bizItemObjFromItemGroup, responseMap, bizItemObjFromDB, value)) {
                return;
            }
            this.validateAccuracy(bizDataDy, bizItemObjFromDB, responseMap, currencyObj);
        } else if (DataGradeValueTypeEnum.DATE.getCode().equals(dataType)) {
            this.validateValueOfDate(bizItemObjFromItemGroup, bizDataDy, responseMap, bizItemObjFromDB);
        } else if (DataGradeValueTypeEnum.TEXT.getCode().equals(dataType)) {
            String value = bizDataDy.getString("value");
            int size = value.length();
            logger.info(MessageFormat.format("size is {0}", size));
            Integer dataLength = bizItemObjFromItemGroup.getInt("bizitem.datalength");
            logger.info(MessageFormat.format("dataLength is {0}", dataLength));
            if (dataLength != null && size > dataLength) {
                responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1090.getCode());
            }
        }
    }

    private BigDecimal parseValueToDecimal(DynamicObject bizDataBillEntry, Map<String, Object> responseMap) {
        BigDecimal value;
        try {
            value = new BigDecimal(bizDataBillEntry.getString("value"));
        }
        catch (Exception exception) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
            return null;
        }
        return value;
    }

    private boolean validateMaxMin(DynamicObject bizItemObjFromItemGroup, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB, BigDecimal value) {
        BigDecimal maxVal;
        Boolean isMinValNull = bizItemObjFromDB.getBoolean("isminvalnull");
        Boolean isMaxValNull = bizItemObjFromDB.getBoolean("ismaxvalnull");
        BigDecimal minVal = isMinValNull != false ? null : bizItemObjFromDB.getBigDecimal("minvalue");
        BigDecimal bigDecimal = maxVal = isMaxValNull != false ? null : bizItemObjFromDB.getBigDecimal("maxvalue");
        if (!SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
            BigDecimal submitMaxValue = bizItemObjFromItemGroup.getBigDecimal("submitmaxvalue");
            BigDecimal submitMinValue = bizItemObjFromItemGroup.getBigDecimal("submitminvalue");
            if (null != submitMinValue) {
                BigDecimal bigDecimal2 = minVal = isMinValNull != false ? submitMinValue : submitMinValue.max(minVal);
            }
            if (null != submitMaxValue) {
                BigDecimal bigDecimal3 = maxVal = isMaxValNull != false ? submitMaxValue : submitMaxValue.min(maxVal);
            }
        }
        if (!SWCObjectUtils.isEmpty((Object)minVal) && value.compareTo(minVal) < 0 || !SWCObjectUtils.isEmpty((Object)maxVal) && value.compareTo(maxVal) > 0) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
            return true;
        }
        return false;
    }

    private void validateAccuracy(DynamicObject bizDataBillEntry, DynamicObject bizItemObjFromDB, Map<String, Object> responseMap, DynamicObject currencyObj) {
        BigDecimal value = new BigDecimal(bizDataBillEntry.getString("value"));
        int excelScale = value.stripTrailingZeros().scale();
        String dataType = bizItemObjFromDB.getString("datatype.number");
        if (DataGradeValueTypeEnum.DECIMAL.getCode().equals(dataType)) {
            int scale = this.getScale(bizItemObjFromDB);
            if (excelScale > scale) {
                responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
            } else {
                String newValue = value.setScale(scale, RoundingMode.HALF_UP).toPlainString();
                bizDataBillEntry.set("value", (Object)newValue);
            }
        } else if (DataGradeValueTypeEnum.AMOUNT.getCode().equals(dataType)) {
            int scale = currencyObj.getInt("amtprecision");
            if (scale < excelScale) {
                responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1097.getCode());
            } else {
                String newValue = value.setScale(scale, RoundingMode.HALF_UP).toPlainString();
                bizDataBillEntry.set("value", (Object)newValue);
            }
        }
    }

    private int getScale(DynamicObject bizItem) {
        String scalelimit = bizItem.getString("scalelimit");
        int scale = 10;
        if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
            scale = Integer.parseInt(scalelimit);
        }
        return scale;
    }

    private void validateValueOfDate(DynamicObject bizItemObjFromItemGroup, DynamicObject bizDataBillEntry, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB) {
        Date valueDate;
        String value = bizDataBillEntry.getString("value");
        try {
            valueDate = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
        }
        catch (Exception exception) {
            try {
                valueDate = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy/MM/dd");
            }
            catch (Exception exception2) {
                logger.info("parse_date_is_error");
                responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                return;
            }
        }
        if (valueDate == null) {
            return;
        }
        String valueStr = SWCDateTimeUtils.format((Date)valueDate, (String)"yyyy-MM-dd");
        bizDataBillEntry.set("value", (Object)valueStr);
        Date itemMinDate = bizItemObjFromDB.getDate("earliestdate");
        Date itemMaxDate = bizItemObjFromDB.getDate("lastdate");
        if (!SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
            Date submitStartDate = bizItemObjFromItemGroup.getDate("submitstartdate");
            Date submitEndDate = bizItemObjFromItemGroup.getDate("submitenddate");
            itemMinDate = BizDataHelper.getMaxDate((Date)itemMinDate, (Date)submitStartDate);
            itemMaxDate = BizDataHelper.getMinDate((Date)itemMaxDate, (Date)submitEndDate);
        }
        if (!SWCObjectUtils.isEmpty((Object)itemMinDate) && valueDate.before(itemMinDate)) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1093.getCode());
            return;
        }
        if (!SWCObjectUtils.isEmpty((Object)itemMaxDate) && valueDate.after(itemMaxDate)) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1093.getCode());
        }
    }

    private void validateCurrency(DynamicObject currencyDy, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB) {
        if (!responseMap.isEmpty() || SWCObjectUtils.isEmpty((Object)bizItemObjFromDB)) {
            return;
        }
        boolean isAmount = DataGradeValueTypeEnum.AMOUNT.getCode().equals(bizItemObjFromDB.getString("datatype.number"));
        if (!isAmount) {
            return;
        }
        DynamicObjectCollection currencyObjs = bizItemObjFromDB.getDynamicObjectCollection("currency");
        if (!CollectionUtils.isEmpty((Collection)currencyObjs)) {
            ArrayList currencyList = new ArrayList();
            currencyObjs.stream().forEach(currencyObj -> currencyList.add((Long)currencyObj.get("fbasedataid_id")));
            if (!SWCObjectUtils.isEmpty((Object)currencyDy)) {
                Long currencyId = currencyDy.getLong("id");
                if (!currencyList.contains(currencyId)) {
                    responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1095.getCode());
                }
            } else {
                responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1094.getCode());
            }
        } else if (SWCObjectUtils.isEmpty((Object)currencyDy)) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1094.getCode());
        }
    }

    private void validateIsExistsAmountItemForCurrency(DynamicObject currencyDyExcel, DynamicObject bizDataDy, Map<Long, DynamicObject> bizItemObjMap, Map<String, Object> responseMap) {
        if (SWCObjectUtils.isEmpty((Object)currencyDyExcel)) {
            return;
        }
        long bizItemIdFromBillEntry = bizDataDy.getLong("bizitem.id");
        DynamicObject bizItemObjFromDB = bizItemObjMap.get(bizItemIdFromBillEntry);
        if (bizItemObjFromDB == null) {
            return;
        }
        boolean isAmount = DataGradeValueTypeEnum.AMOUNT.getCode().equals(bizItemObjFromDB.getString("datatype.number"));
        if (!isAmount) {
            responseMap.put("key_result_error_msg", BizDataFailStatusEnum.FAILSTATUS_1088.getCode());
        }
    }

    private DynamicObject[] getBizItemObj(ExtendedDataEntity[] dataEntities) {
        Set bizItemIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("bizitem.id")).collect(Collectors.toSet());
        DynamicObject[] queryBizItems = HPDIDataServiceHelper.HSBS_BIZITEM_HELPER.query("id,currency,datatype,scalelimit,isminvalnull,ismaxvalnull,minvalue,maxvalue,earliestdate,lastdate,cycle", new QFilter[]{new QFilter("id", "in", bizItemIds)});
        return queryBizItems;
    }

    private Map<Long, DynamicObject> getBizItemFormBizItemGroup(Long bizItemGrpId) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> bizItemGrpIdList = new ArrayList<Long>(1);
        bizItemGrpIdList.add(bizItemGrpId);
        DynamicObject[] itemGroupList = null;
        try {
            itemGroupList = HPDIServiceUtils.getBizItemGroupById(bizItemGrpIdList);
        }
        catch (Exception exception) {
            logger.error(MessageFormat.format("BizDataHelper-getBizItemFormBizItemGroup getBizItemGroupById Exception:", exception));
        }
        if (itemGroupList == null || itemGroupList.length == 0) {
            return result;
        }
        DynamicObject queryBizItemGroup = itemGroupList[0];
        DynamicObjectCollection bizItems = queryBizItemGroup.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)bizItems)) {
            return result;
        }
        Map<Long, DynamicObject> bizItemMap = bizItems.stream().collect(Collectors.toMap(bu -> bu.getLong("bizitem.id"), bu -> bu, (k1, k2) -> k1));
        return bizItemMap;
    }

    protected void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        String returnErrorCode = this.getOption().getVariableValue("return_error_code", "false");
        if (!"true".equals(returnErrorCode)) {
            String desc = BizDataFailStatusEnum.getDesc((String)content);
            if (desc == null) {
                desc = content;
            }
            super.addErrorMessage(dataEntity, desc);
        } else {
            super.addErrorMessage(dataEntity, content);
        }
    }
}

