/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.cloudcolla;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class PayRollActGrpFieldMapValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpFieldMapValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            this.checkIfFieldMapNotChoose(extendedDataEntity);
        }
    }

    private void checkIfFieldMapNotChoose(ExtendedDataEntity extendedDataEntity) {
        DynamicObject payRollGrpDyObj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryEntities = payRollGrpDyObj.getDynamicObjectCollection("entryentity");
        Map payRollActIsMustFieldMapRel = HPDICloudCollaHelper.getInstance().getPayRollActGrpIsMustFieldMap(entryEntities);
        if (!CollectionUtils.isEmpty((Map)payRollActIsMustFieldMapRel)) {
            for (DynamicObject entryEntity : entryEntities) {
                this.validateFieldMapNotChoose(payRollActIsMustFieldMapRel, extendedDataEntity, entryEntity);
            }
        }
    }

    private void validateFieldMapNotChoose(Map<String, Boolean> payRollActIsMustFieldMapRel, ExtendedDataEntity extendedDataEntity, DynamicObject entryEntity) {
        List collect;
        DynamicObject payRollActDyobj = entryEntity.getDynamicObject("payrollact");
        if (!payRollActIsMustFieldMapRel.getOrDefault(payRollActDyobj.getString("id"), Boolean.FALSE).booleanValue()) {
            return;
        }
        SWCDataServiceHelper triggerCollaOrm = new SWCDataServiceHelper("hsbs_triggercolla");
        DynamicObjectCollection triggerList = payRollActDyobj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)triggerList)) {
            return;
        }
        List triggerIds = triggerList.stream().map(tr -> tr.getDynamicObject("triggercolla").getLong("id")).collect(Collectors.toList());
        DynamicObject[] triggerObjs = triggerCollaOrm.query("ismustfieldmapping,entityobject", new QFilter[]{new QFilter("id", "in", triggerIds)});
        if (null == triggerObjs || triggerObjs.length == 0) {
            return;
        }
        ArrayList<String> mustMappedField = new ArrayList<String>();
        for (int i = 0; i < triggerObjs.length; ++i) {
            if (!"1".equals(triggerObjs[i].getString("ismustfieldmapping"))) continue;
            mustMappedField.add(triggerObjs[i].getString("entityobject.number"));
        }
        ArrayList isMappedField = new ArrayList(10);
        DynamicObjectCollection fieldMapEntryEntity = entryEntity.getDynamicObjectCollection("subentryentity");
        if (!CollectionUtils.isEmpty((Collection)fieldMapEntryEntity) && !CollectionUtils.isEmpty(collect = fieldMapEntryEntity.stream().map(field -> field.getDynamicObjectCollection("actgfieldmapobj")).collect(Collectors.toList()))) {
            for (DynamicObjectCollection row : collect) {
                if (CollectionUtils.isEmpty((Collection)row)) continue;
                isMappedField.addAll(row.stream().map(objs -> objs.getString("fbasedataid.number")).collect(Collectors.toList()));
            }
        }
        ArrayList<String> msgStr = new ArrayList<String>(10);
        for (String field2 : mustMappedField) {
            if (isMappedField.contains(field2)) continue;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)field2);
            msgStr.add(dataEntityType.getDisplayName().toString());
        }
        if (!CollectionUtils.isEmpty(msgStr)) {
            String join = String.join((CharSequence)"\u201d\u3001\u201c", msgStr);
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u9762\u677f\u7684\u201c{0}\u201d\u4e2d\u7684\u201c{1}\u201d\u672a\u9009\u62e9\u5b57\u6bb5\u6620\u5c04\u65b9\u6848\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"PayRollActGrpValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[0]), payRollActDyobj.getString("name"), join));
        }
    }
}

