/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.verify;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;

public class SummaryVerifyBillCreateTaskValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataList = this.getDataEntities();
        HashMap<String, Set> ctClassIdMap = new HashMap<String, Set>(16);
        for (ExtendedDataEntity extendedDataEntity : dataList) {
            DynamicObject dataEntity;
            String ctClass = (dataEntity = extendedDataEntity.getDataEntity()).getString("collataskclass");
            DynamicObjectCollection ctObjectList = dataEntity.getDynamicObjectCollection("hpdi_collatask".equalsIgnoreCase(ctClass) ? "mulcollatask" : "multaskcenter");
            if (CollectionUtils.isEmpty((Collection)ctObjectList)) continue;
            Set idSet = ctClassIdMap.computeIfAbsent(ctClass, item -> new HashSet(16));
            idSet.addAll(ctObjectList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        }
        Table ctTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(ctClassIdMap);
        HashMap existTaskAppMap = new HashMap(16);
        for (ExtendedDataEntity extendedDataEntity : dataList) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String billStatus = dataEntity.getString("billstatus");
            if (!"C".equalsIgnoreCase(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u6838\u5b9a\u5355\u624d\u80fd\u521b\u5efa\u4efb\u52a1\u3002", (String)"SummaryVerifyBillCreateTaskValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection verifyApps = dataEntity.getDynamicObjectCollection("verifyapp");
            Set currentVerifyAppSet = verifyApps.stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet());
            String ctClass = dataEntity.getString("collataskclass");
            DynamicObjectCollection ctObjectList = dataEntity.getDynamicObjectCollection("hpdi_collatask".equalsIgnoreCase(ctClass) ? "mulcollatask" : "multaskcenter");
            if (CollectionUtils.isEmpty((Collection)ctObjectList)) continue;
            HashSet existTaskAppSet = new HashSet(16);
            for (DynamicObject collaTask : ctObjectList) {
                long crId = collaTask.getLong("fbasedataid.id");
                DynamicObject taskCenter = (DynamicObject)ctTable.get((Object)ctClass, (Object)crId);
                if (taskCenter == null || !"1".equalsIgnoreCase(taskCenter.getString("enable"))) continue;
                existTaskAppSet.addAll(taskCenter.getDynamicObjectCollection("collaapp").stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet()));
            }
            if (currentVerifyAppSet.size() == existTaskAppSet.size()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u534f\u4f5c\u4efb\u52a1\u3002", (String)"SummaryVerifyBillCreateTaskValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
            }
            existTaskAppMap.put(dataEntity.getLong("id"), existTaskAppSet);
        }
        this.getOption().setVariableValue("existTaskAppMap", SerializationUtils.serializeToBase64(existTaskAppMap));
    }
}

