/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.validator.verify;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;

public class SummaryVerifyBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            Set tempIds;
            DynamicObject data = dataEntity.getDataEntity();
            String billStatus = data.getString("billstatus");
            if (!"C".equalsIgnoreCase(billStatus)) continue;
            DynamicObjectCollection mulcollatasks = data.getDynamicObjectCollection("mulcollatask");
            DynamicObjectCollection multaskcenters = data.getDynamicObjectCollection("multaskcenter");
            HashMap<String, Set> param = new HashMap<String, Set>(16);
            for (DynamicObject task : mulcollatasks) {
                tempIds = param.computeIfAbsent("hpdi_collatask", item -> new HashSet(16));
                tempIds.add(task.getLong("fbasedataid_id"));
            }
            for (DynamicObject task : multaskcenters) {
                tempIds = param.computeIfAbsent("hpdi_taskcenter", item -> new HashSet(16));
                tempIds.add(task.getLong("fbasedataid_id"));
            }
            Table collaTaskTable2 = HPDICloudCollaHelper.getInstance().queryMultiClassObject(param);
            Map<Long, DynamicObject> collaTaskMap = collaTaskTable2.values().stream().collect(Collectors.toMap(item -> item.getLong("id"), val -> val, (v1, v2) -> v1));
            HashSet<String> execingTaskName = new HashSet<String>(mulcollatasks.size());
            HashSet<String> succTaskName = new HashSet<String>(mulcollatasks.size());
            Boolean isAllSuccess = Boolean.TRUE;
            if (mulcollatasks.size() != 0) {
                isAllSuccess = this.validateTaskExecuteStatus(mulcollatasks, collaTaskMap, execingTaskName, succTaskName, isAllSuccess);
            }
            if (multaskcenters.size() != 0) {
                isAllSuccess = this.validateTaskExecuteStatus(multaskcenters, collaTaskMap, execingTaskName, succTaskName, isAllSuccess);
            }
            String del = ResManager.loadKDString((String)"\u201d\uff0c\u201c", (String)"SummaryVerifyBillUnAuditValidator_2", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
            if (execingTaskName.size() >= 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u5931\u8d25\uff1a\u534f\u4f5c\u4efb\u52a1\u201c{0}\u201d\u6267\u884c\u4e2d\uff0c\u6267\u884c\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u53cd\u5ba1\u6279\u3002", (String)"SummaryVerifyBillUnAuditValidator_0", (String)"swc-hpdi-opplugin", (Object[])new Object[]{String.join((CharSequence)del, execingTaskName)}));
            }
            if (!isAllSuccess.booleanValue() || succTaskName.size() < 1) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u8054\u7684\u534f\u4f5c\u4efb\u52a1\u201c{0}\u201d\u5df2\u6839\u636e\u6838\u5b9a\u5355\u6267\u884c\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"SummaryVerifyBillUnAuditValidator_1", (String)"swc-hpdi-opplugin", (Object[])new Object[]{String.join((CharSequence)del, succTaskName)}));
        }
    }

    private Boolean validateTaskExecuteStatus(DynamicObjectCollection mulcollatasks, Map<Long, DynamicObject> collaTaskMap, Set<String> execingTaskName, Set<String> succTaskName, Boolean isAllSuccess) {
        block0: for (DynamicObject mulcollatask : mulcollatasks) {
            DynamicObject collaTask = collaTaskMap.get(mulcollatask.getLong("fbasedataid_id"));
            if (collaTask == null) continue;
            String taskStatus = collaTask.getString("taskexecutestatus");
            if ("C".equalsIgnoreCase(taskStatus)) {
                execingTaskName.add(collaTask.getString("name"));
                continue;
            }
            DynamicObjectCollection taskCenterEntry = collaTask.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)taskCenterEntry)) continue;
            for (DynamicObject taskCenterEntryObj : taskCenterEntry) {
                String exeStatus = taskCenterEntryObj.getString("taskexecutestatusent");
                if (!taskCenterEntryObj.getBoolean("ismanualverify")) continue;
                if ("D".equalsIgnoreCase(exeStatus) || "C".equalsIgnoreCase(exeStatus)) {
                    succTaskName.add(collaTask.getString("name"));
                    continue;
                }
                isAllSuccess = Boolean.FALSE;
                continue block0;
            }
        }
        return isAllSuccess;
    }
}

