/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataRollBackHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.opplugin.validator.bizdata.BizDataAbandonValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;

public class BizDataAbandonOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bizdatastatus");
        fieldKeys.add("bizdatacode");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new BizDataAbandonValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs transactionArgs) {
        Object[] dataEntities = transactionArgs.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        ArrayList<Long> pkIdList = new ArrayList<Long>(dataEntities.length);
        for (Object dataEntity : dataEntities) {
            pkIdList.add(dataEntity.getLong("id"));
        }
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("id", "in", pkIdList);
        DynamicObject[] bizDataArr = bizDataHelper.query("id,bizdatastatus,bizdatacode,applyno,submission,empposorgrel,salaryfile,empposorgrel.adminorg,bizitemgroup,bizitem,bizdatadim", new QFilter[]{bizDataFilter});
        ArrayList<DynamicObject> waitSaveOperateLogs = new ArrayList<DynamicObject>(bizDataArr.length);
        HashBasedTable statusTable = HashBasedTable.create();
        for (DynamicObject bizDataDy : bizDataArr) {
            waitSaveOperateLogs.add(BizDataRollBackHelper.assembleOperateLogForStatus((DynamicObject)bizDataDy, (boolean)false, (String)BizDataStatusEnum.getDesc((String)bizDataDy.getString("bizdatastatus")), (String)BizDataStatusEnum.DISABLED.getDesc(), (String)BizDataOperateEnum.OPERATE_ABANDON.getCode()));
            bizDataDy.set("bizdatastatus", (Object)BizDataStatusEnum.DISABLED.getCode());
            if (!"1".equals(bizDataDy.getString("submission"))) continue;
            statusTable.put((Object)bizDataDy.getString("bizdatacode"), (Object)bizDataDy.getString("applyno"), (Object)bizDataDy.getString("bizdatastatus"));
        }
        bizDataHelper.update(bizDataArr);
        HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(waitSaveOperateLogs.toArray(new DynamicObject[0]));
        BizDataBillEntryHelper.updateTransSalaryStatus((Table)statusTable);
    }
}

