/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.enums.OperateStep;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.AddTransSalaryService;
import kd.swc.hpdi.business.service.UpdateTransSalaryService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;

public class BizDataBillEventOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BizDataBillEventOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        BizDataHelper.addFieldKeys((List)fieldKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] regBillObjs = args.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : regBillObjs) {
            Long id = dynamicObject.getLong("id");
            billIdList.add(id);
        }
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter filter = new QFilter("id", "in", billIdList);
        DynamicObject[] needUpdateBillDy = helper.query("id,billstatus,auditdate,datastatus,entryentity.bizdatastatus,entryentity.errormsg", new QFilter[]{filter});
        switch (args.getOperationKey()) {
            case "wfreject": {
                this.rejectDo(needUpdateBillDy);
                break;
            }
            case "wfrejecttosubmit": {
                this.rejectToSubmitDo(needUpdateBillDy);
                break;
            }
            case "wfauditing": {
                this.audittingDo(needUpdateBillDy);
                break;
            }
            case "dosubmit": {
                this.doSubmitDo(needUpdateBillDy);
                break;
            }
            case "wfauditpass": {
                this.auditPassDo(needUpdateBillDy);
                break;
            }
            case "wfauditnotpass": {
                this.auditNotPassDo(needUpdateBillDy);
                break;
            }
        }
        helper.update(needUpdateBillDy);
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        switch (args.getOperationKey()) {
            case "wfauditpass": {
                DynamicObject[] dataEntities;
                for (DynamicObject obj : dataEntities = args.getDataEntities()) {
                    logger.info("submissionDo_start");
                    try {
                        BizDataHelper.submissionDo((DynamicObject)obj);
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                    logger.info("submissionDo_end");
                }
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject obj : dataEntities = args.getDataEntities()) {
            String tranSalaryMode = obj.getString("bizitemgroup.transalarymode");
            if ("1".equals(tranSalaryMode)) continue;
            SWCThreadPoolFactory.getBizdataSyncThreadpool().execute(() -> {
                logger.info("transSalary_start KEY_APPLY_NO is {}, KEY_BILL_TYPE is {}", (Object)obj.getString("billno"), (Object)obj.getString("billtype"));
                SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
                QFilter bizDataFilter = new QFilter("applyno", "=", (Object)obj.getString("billno"));
                DynamicObject[] bizDataArr = bizDataHelper.query("id, bizdatastatus, batchnum, empposorgrel, salaryfile, payrollgrp, bizitemgroup, bizitemgroup.calperiodtype.id, bizitem, currency, effectivedate, expirydate, bizdatacode, description, value, transsalaryerror, submitdate, errormsg, billtype, calfrequency, bizdatarecord, depemp", new QFilter[]{bizDataFilter});
                List bizDatasSplit = BizDataHelper.splitBizData(Arrays.asList(bizDataArr));
                for (List bizDatas : bizDatasSplit) {
                    try (TXHandle txHandle = TX.requiresNew();){
                        if ("2".equals(obj.getString("billtype"))) {
                            BizDataHelper.getTransSalaryService(UpdateTransSalaryService.class).transSalary(bizDatas, OperateStep.AUTO_TRANS_SALARY.getCode());
                            return;
                        }
                        BizDataHelper.getTransSalaryService(AddTransSalaryService.class).transSalary(bizDatas, OperateStep.AUTO_TRANS_SALARY.getCode());
                        txHandle.commit();
                    }
                }
                logger.info("transSalary_end");
            });
        }
    }

    private void rejectDo(DynamicObject[] regBillObjs) {
        this.setApproveBillStatus(regBillObjs, "D");
    }

    private void rejectToSubmitDo(DynamicObject[] regBillObjs) {
        this.setApproveBillStatus(regBillObjs, "G");
    }

    private void audittingDo(DynamicObject[] regBillObjs) {
        this.setApproveBillStatus(regBillObjs, "D");
    }

    private void doSubmitDo(DynamicObject[] regBillObjs) {
        this.setApproveBillStatus(regBillObjs, "D");
    }

    private void auditPassDo(DynamicObject[] regBillObjs) {
        this.setApproveBillStatus(regBillObjs, "C");
        for (DynamicObject dynamicObject : regBillObjs) {
            dynamicObject.set("auditdate", (Object)new Date());
        }
    }

    private void auditNotPassDo(DynamicObject[] regBillObjs) {
        this.setApproveBillStatus(regBillObjs, "E");
    }

    private void setApproveBillStatus(DynamicObject[] regBillObjs, String billStatus) {
        for (DynamicObject dynamicObject : regBillObjs) {
            dynamicObject.set("billstatus", (Object)billStatus);
        }
    }
}

