/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataRollBackHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.opplugin.validator.bizdata.BizDataRecordAbandonValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;

public class BizDataRecordAbandonOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bizdatastatus");
        fieldKeys.add("bizdatacode");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new BizDataRecordAbandonValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] bizDataArr;
        Object[] dataEntities = args.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        List pkIdList = Arrays.stream(dataEntities).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper bizDataRecordHelper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
        QFilter qFilter = new QFilter("id", "in", pkIdList);
        DynamicObject[] bizDataRecords = bizDataRecordHelper.query("id,bizdatastatus,bizdatacode,applyno,submission,empposorgrel,salaryfile,empposorgrel.adminorg,bizitemgroup,bizdatadim", qFilter.toArray());
        ArrayList<DynamicObject> waitSaveOperateLogs = new ArrayList<DynamicObject>(bizDataRecords.length);
        HashBasedTable statusTable = HashBasedTable.create();
        for (DynamicObject record : bizDataRecords) {
            waitSaveOperateLogs.add(BizDataRollBackHelper.assembleOperateLogForStatus((DynamicObject)record, (boolean)true, (String)BizDataStatusEnum.getDesc((String)record.getString("bizdatastatus")), (String)BizDataStatusEnum.DISABLED.getDesc(), (String)BizDataOperateEnum.OPERATE_ABANDON.getCode()));
            record.set("bizdatastatus", (Object)BizDataStatusEnum.DISABLED.getCode());
            if (!"1".equals(record.getString("submission"))) continue;
            statusTable.put((Object)record.getString("bizdatacode"), (Object)record.getString("applyno"), (Object)record.getString("bizdatastatus"));
        }
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("bizdatarecord", "in", pkIdList);
        for (DynamicObject bizDataDy : bizDataArr = bizDataHelper.query("id,bizdatastatus", new QFilter[]{bizDataFilter})) {
            bizDataDy.set("bizdatastatus", (Object)BizDataStatusEnum.DISABLED.getCode());
        }
        bizDataRecordHelper.update(bizDataRecords);
        bizDataHelper.update(bizDataArr);
        HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(waitSaveOperateLogs.toArray(new DynamicObject[0]));
        BizDataBillEntryHelper.updateTransSalaryStatus((Table)statusTable);
    }
}

