/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.verify.SumVerifyBillEventBus;
import kd.swc.hpdi.business.verify.event.ClearTaskIdEvent;
import kd.swc.hpdi.opplugin.validator.basedate.TaskCenterDisableValidator;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterDisableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs event) {
        List fieldKeys = event.getFieldKeys();
        fieldKeys.add("enable");
        fieldKeys.add("taskexecutestatus");
        fieldKeys.add("orgmsgrecvcenter");
        fieldKeys.add("executeseq");
        fieldKeys.add("sumverifybillid");
    }

    public void endOperationTransaction(EndOperationTransactionArgs event) {
        super.endOperationTransaction(event);
        DynamicObject[] dataEntities = event.getDataEntities();
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hpdi_summaryvbill");
        Set idList = Arrays.stream(dataEntities).filter(item -> item.getLong("sumverifybillid") != 0L).map(item -> item.getLong("sumverifybillid")).collect(Collectors.toSet());
        DynamicObject[] queryData = swcDataServiceHelper.queryOriginalArray("id", new QFilter[]{new QFilter("id", "in", idList)});
        Set existBillIds = Arrays.stream(queryData).map(item -> item.getLong("id")).collect(Collectors.toSet());
        HashMap<String, Cloneable> param = new HashMap<String, Cloneable>(16);
        param.put("summaryIds", new ArrayList(existBillIds));
        HashMap<Long, Set> clearDataMap = new HashMap<Long, Set>(16);
        for (DynamicObject dataEntity : dataEntities) {
            long billId = dataEntity.getLong("sumverifybillid");
            Set taskIds = clearDataMap.computeIfAbsent(billId, item -> new HashSet(16));
            taskIds.add(dataEntity.getLong("id"));
        }
        param.put("clearDataMap", clearDataMap);
        ClearTaskIdEvent clearTaskIdEvent = new ClearTaskIdEvent(param);
        SumVerifyBillEventBus.getInstance().post((AbstractVerifyBillEvent)clearTaskIdEvent);
        if (!clearTaskIdEvent.isSuccess()) {
            throw new KDBizException(CollaMsgVerifyBillHelper.getInstance().getErrorTips());
        }
        this.setOrgMsgRecvCenterStatus(dataEntities);
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new TaskCenterDisableValidator());
    }

    private void setOrgMsgRecvCenterStatus(DynamicObject[] dataEntities) {
        SWCDataServiceHelper billHelper;
        DynamicObject[] billData;
        ArrayList<Long> idList = new ArrayList<Long>(dataEntities.length);
        String collaTaskClass = null;
        for (DynamicObject dataEntity : dataEntities) {
            if (SWCStringUtils.isEmpty(collaTaskClass)) {
                collaTaskClass = dataEntity.getDynamicObjectType().getName();
            }
            idList.add(dataEntity.getLong("orgmsgrecvcenter.id"));
        }
        if (SWCStringUtils.isEmpty(collaTaskClass)) {
            return;
        }
        SWCDataServiceHelper taskCenterOrm = new SWCDataServiceHelper(collaTaskClass);
        QFilter msgRecvFilter = new QFilter("orgmsgrecvcenter.id", "in", idList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] databaseEnableTaskRules = taskCenterOrm.query("id,status,enable,orgmsgrecvcenter", new QFilter[]{msgRecvFilter, enableFilter});
        ArrayList<Long> removeIds = new ArrayList<Long>(10);
        if (databaseEnableTaskRules != null && databaseEnableTaskRules.length != 0) {
            for (DynamicObject taskRule : databaseEnableTaskRules) {
                removeIds.add(taskRule.getLong("orgmsgrecvcenter.id"));
            }
        }
        if ((billData = (billHelper = new SWCDataServiceHelper("hpdi_summaryvbill")).query("id,orgmsgrecvcenter.id", new QFilter[]{new QFilter("billstatus", "not in", (Object)new String[]{"E", "F"}), new QFilter("orgmsgrecvcenter.id", "in", idList)})) != null && billData.length != 0) {
            for (DynamicObject billDatum : billData) {
                removeIds.add(billDatum.getLong("orgmsgrecvcenter.id"));
            }
        }
        idList.removeAll(removeIds);
        SWCDataServiceHelper msgRecvOrm = new SWCDataServiceHelper("hpdi_msgreceive");
        QFilter taskCenterFilter = new QFilter("id", "in", idList);
        DynamicObject[] msgRecvObjs = msgRecvOrm.query("taskcreatestatus", new QFilter[]{taskCenterFilter});
        if (msgRecvObjs == null || msgRecvObjs.length == 0) {
            return;
        }
        for (DynamicObject orgMsgRecvCenterObj : msgRecvObjs) {
            orgMsgRecvCenterObj.set("taskcreatestatus", (Object)"A");
        }
        msgRecvOrm.update(msgRecvObjs);
    }
}

