/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterDataHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterExecuteAsyncHelper;
import kd.swc.hpdi.opplugin.validator.basedate.TaskCenterExecuteDataStatusValidator;
import kd.swc.hpdi.opplugin.validator.basedate.TaskCenterExecuteTaskValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class TaskCenterExecuteTaskOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(TaskCenterExecuteTaskOp.class);
    private static final String[] SAVE_FIELDS = new String[]{"executeseq", "enable", "taskexecutestatus", "taskrule", "taskrulev", "orgmsgrecvcenter.msgsubno", "orgmsgrecvcenter.msgcontent", "orgmsgrecvcenter.taskcreatestatus", "orgmsgrecvcenter.msgaction.actiontype", "orgmsgrecvcenter.enable", "taskexecutenum", "orgmsgrecvcenter.msgcontent", "taskexecutedate", "executefailmsg", "entryentity", "entryentity.seq", "entryentity.collarule", "entryentity.collarule.sourcevid", "entryentity.collarulev", "entryentity.collarule", "entryentity.collarulev", "entryentity.collaruleclass", "entryentity.stopexecafterfail", "entryentity.taskexecutestatusent", "entryentity.executefailmsgent", "entryentity.taskexecutetime", "entryentity.taskexecmanner", "entryentity.taskexecuser", "entryentity.ismanualverify", "entryentity.result", "flowtype", "sumverifybillid", "org", "collaapp", "executeseq", "arrangeseq"};

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.addAll(Arrays.asList(SAVE_FIELDS));
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TaskCenterExecuteTaskValidator());
        args.addValidator((AbstractValidator)new TaskCenterExecuteDataStatusValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        this.dataEntities = (DynamicObject[])Arrays.stream(dataEntities).peek(ent -> ent.getDynamicObjectCollection("entryentity").stream().filter(dt -> dt.getString("taskexecutestatusent").equals("D"))).toArray(DynamicObject[]::new);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        this.resetCollaRuleDyn(dataEntities);
        String taskExecManner = this.getOption().getVariableValue("taskexecmanner", "manual");
        LinkedHashMap<DynamicObject, Object> executeData = new LinkedHashMap<DynamicObject, Object>(dataEntities.length);
        Set<String> uniqueKeySet = this.getUniqueKey(dataEntities);
        TaskCenterDataHelper taskCenterHelper = new TaskCenterDataHelper();
        for (DynamicObject dataEntity : dataEntities) {
            int executeSeq = dataEntity.getInt("executeseq");
            List msgEntities = HPDICollaMsgServiceHelper.getInstance().splitMsgReceiveLog(dataEntity.getDynamicObject("orgmsgrecvcenter"));
            int index = executeSeq - 1;
            if (msgEntities == null || index < 0 || index >= msgEntities.size()) {
                String msg = ResManager.loadKDString((String)"\u8be5\u534f\u4f5c\u4efb\u52a1\u7684\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"TaskCenterExecuteTaskOp_0", (String)"swc-hpdi-opplugin", (Object[])new Object[0]);
                dataEntity.set("taskexecutestatus", (Object)"E");
                dataEntity.set("executefailmsg", (Object)msg);
                continue;
            }
            if ("auto".equals(taskExecManner)) {
                if (!uniqueKeySet.contains(taskCenterHelper.generateKey(dataEntity))) continue;
                executeData.put(dataEntity, msgEntities.get(index));
                this.resetTaskRunStatus(dataEntity);
                continue;
            }
            executeData.put(dataEntity, msgEntities.get(index));
            this.resetTaskRunStatus(dataEntity);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        LOGGER.info("[colla]: before task center execute task, executeData.size() = {}", (Object)executeData.size());
        executeData.forEach((key, value) -> {
            LOGGER.info("[colla]: mannal run colla task, msgEntity = {}", value);
            TaskCenterExecuteAsyncHelper.getInstance().executeTask(key, value, taskExecManner);
        });
    }

    private Set<String> getUniqueKey(DynamicObject[] dataEntities) {
        HashMap<Long, String> keyMap = new HashMap<Long, String>(16);
        TaskCenterDataHelper taskCenterHelper = new TaskCenterDataHelper();
        for (DynamicObject dataEntity : dataEntities) {
            String uniqueKey = taskCenterHelper.generateKey(dataEntity);
            long msgId = dataEntity.getLong("orgmsgrecvcenter.id");
            keyMap.compute(msgId, (key, oldValue) -> {
                if (oldValue == null) {
                    return uniqueKey;
                }
                return oldValue.compareTo(uniqueKey) < 0 ? oldValue : uniqueKey;
            });
        }
        return new HashSet<String>(keyMap.values());
    }

    private void resetCollaRuleDyn(DynamicObject[] dataEntities) {
        HPDICloudCollaHelper collaHelper = HPDICloudCollaHelper.getInstance();
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        Arrays.stream(dataEntities).forEach(ent -> ent.getDynamicObjectCollection("entryentity").forEach(obj -> {
            Set collaRuleIds = param.computeIfAbsent(obj.getString("collaruleclass"), k -> Sets.newHashSetWithExpectedSize((int)16));
            collaRuleIds.add(obj.getLong("collarule.id"));
        }));
        Table collaRuleClassIds = collaHelper.queryMultiClassObject((Map)param);
        if (collaRuleClassIds == null || collaRuleClassIds.isEmpty()) {
            return;
        }
        Arrays.stream(dataEntities).forEach(ent -> ent.getDynamicObjectCollection("entryentity").stream().forEach(obj -> obj.set("collarule", collaRuleClassIds.get((Object)obj.getString("collaruleclass"), (Object)obj.getLong("collarule.id")))));
    }

    private void resetTaskRunStatus(DynamicObject dataEntity) {
        dataEntity.set("taskexecutestatus", (Object)"C");
        dataEntity.set("taskexecutedate", (Object)new Date());
        dataEntity.set("executefailmsg", (Object)"");
        dataEntity.set("taskexecutenum", (Object)(dataEntity.getInt("taskexecutenum") + 1));
        DynamicObjectCollection entryEnties = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryEnties) {
            String taskStatus = entity.getString("taskexecutestatusent");
            if ("D".equals(taskStatus)) continue;
            entity.set("taskexecutestatusent", (Object)"B");
            entity.set("executefailmsgent", (Object)"");
            entity.set("taskexecutetime", (Object)"");
            entity.set("taskexecmanner", null);
            entity.set("taskexecuser", null);
            entity.set("result", null);
        }
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        super.onReturnOperation(args);
        if (this.operationResult.isSuccess()) {
            return;
        }
        String taskExecuteManner = this.getOption().getVariableValue("taskexecmanner", "manner");
        if (!"auto".equalsIgnoreCase(taskExecuteManner)) {
            return;
        }
        if (this.operationResult.isSuccess()) {
            return;
        }
        List allErrorOrValidateInfo = this.getOperationResult().getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            return;
        }
        String errorMsg = this.operationResult.getMessage();
        HashMap<Long, List> messagesMap = new HashMap<Long, List>(16);
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            Long pkValue = (Long)iOperateInfo.getPkValue();
            List msgs = messagesMap.computeIfAbsent(pkValue, item -> new ArrayList(10));
            msgs.add(iOperateInfo.getMessage());
        }
        String taskCenterClass = this.billEntityType.getName();
        SWCDataServiceHelper taskCenterHelper = new SWCDataServiceHelper(taskCenterClass);
        DynamicObject[] query = taskCenterHelper.query("id, taskexecutestatus, executefailmsg", new QFilter[]{new QFilter("id", "in", messagesMap.keySet())});
        ArrayList<DynamicObject> updateMessageObject = new ArrayList<DynamicObject>(query.length);
        for (DynamicObject object : query) {
            long taskId = object.getLong("id");
            List messageList = messagesMap.getOrDefault(taskId, new ArrayList(10));
            if (CollectionUtils.isEmpty((Collection)messageList)) continue;
            object.set("taskexecutestatus", (Object)"E");
            object.set("executefailmsg", (Object)(errorMsg + System.lineSeparator() + messageList.stream().collect(Collectors.joining(System.lineSeparator()))));
            updateMessageObject.add(object);
        }
        taskCenterHelper.save(updateMessageObject.toArray(new DynamicObject[0]));
    }
}

