/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class TaskCenterSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("taskrule");
        fieldKeys.add("status");
        fieldKeys.add("taskrule.immediately");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] data = args.getDataEntities();
        if (data == null || data.length == 0) {
            return;
        }
        for (DynamicObject datum : data) {
            datum.set("status", (Object)"C");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] taskCenters = args.getDataEntities();
        if (taskCenters == null || taskCenters.length == 0) {
            return;
        }
        ArrayList<Long> immediatelyTaskIds = new ArrayList<Long>(taskCenters.length);
        for (DynamicObject taskCenter : taskCenters) {
            if (!taskCenter.getBoolean("taskrule.immediately")) continue;
            immediatelyTaskIds.add(taskCenter.getLong("id"));
        }
        String taskCenterClass = Arrays.stream(taskCenters).findFirst().map(item -> item.getDynamicObjectType().getName()).orElse("hpdi_taskcenter");
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper(taskCenterClass);
        DynamicObject[] query = swcDataServiceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)taskCenterClass), new QFilter[]{new QFilter("id", "in", immediatelyTaskIds)});
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.toString(true));
        option.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
        option.setVariableValue("taskexecmanner", "auto");
        OperationServiceHelper.executeOperate((String)"executetask", (String)taskCenterClass, (DynamicObject[])query, (OperateOption)option);
    }
}

