/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.basedata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class TaskRuleDataStatusMutexOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("createorg");
        fieldKeys.add("msgsubscriber");
        fieldKeys.add("enable");
        fieldKeys.add("boid");
        fieldKeys.add("status");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet<Long> boIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> createIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> msgSubscriberIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            if (!"C".equalsIgnoreCase(dataEntity.getString("status"))) continue;
            boIds.add(dataEntity.getLong("boid"));
            createIds.add(dataEntity.getLong("createorg.id"));
            msgSubscriberIds.add(dataEntity.getLong("msgsubscriber.id"));
        }
        Map<String, Set<DynamicObject>> dataMap = this.getDataBaseDatas(dataEntities, boIds, createIds, msgSubscriberIds);
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        Set<DynamicObject> targetObjects = this.getNeedDisableDynamicObjects(dataEntities, dataMap);
        if (targetObjects == null || targetObjects.isEmpty()) {
            return;
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        operationService.invokeOperation("disable", targetObjects.toArray(new DynamicObject[0]), null);
    }

    private Set<DynamicObject> getNeedDisableDynamicObjects(DynamicObject[] dataEntities, Map<String, Set<DynamicObject>> dataMap) {
        HashSet<DynamicObject> targetKeys = new HashSet<DynamicObject>(16);
        for (DynamicObject dataEntity : dataEntities) {
            String dataKey;
            Set<DynamicObject> modifyObjects;
            long dataCreateId = dataEntity.getLong("createorg.id");
            long dataMsgSubscriberId = dataEntity.getLong("msgsubscriber.id");
            if (dataCreateId == 0L || dataMsgSubscriberId == 0L || CollectionUtils.isEmpty(modifyObjects = dataMap.get(dataKey = this.appendData(String.valueOf(dataCreateId), String.valueOf(dataMsgSubscriberId))))) continue;
            targetKeys.addAll(modifyObjects);
        }
        return targetKeys;
    }

    private Map<String, Set<DynamicObject>> getDataBaseDatas(DynamicObject[] dataEntities, Set<Long> boIds, Set<Long> createIds, Set<Long> msgSubscriberIds) {
        String formId = this.billEntityType.getExtendName();
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = "hpdi_taskrule";
        }
        SWCDataServiceHelper taskRuleOrm = new SWCDataServiceHelper(formId);
        QFilter createOrgQFilter = new QFilter("createorg", "in", createIds);
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter msgSubscriberQFilter = new QFilter("msgsubscriber.id", "in", msgSubscriberIds);
        QFilter currentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter boIdQFilter = new QFilter("boid", "not in", boIds);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dataBaseTaskRules = taskRuleOrm.query("id,boid,createorg,msgsubscriber,enable,status,immediately,disabler,disabledate", new QFilter[]{createOrgQFilter, msgSubscriberQFilter, currentVersionQFilter, boIdQFilter, enableQFilter, statusQFilter});
        HashMap<String, Set<DynamicObject>> dataMap = new HashMap<String, Set<DynamicObject>>(dataEntities.length);
        if (dataBaseTaskRules == null || dataBaseTaskRules.length == 0) {
            return null;
        }
        for (DynamicObject dataBaseTaskRule : dataBaseTaskRules) {
            long createOrgId = dataBaseTaskRule.getLong("createorg.id");
            long msgSubscriberId = dataBaseTaskRule.getLong("msgsubscriber.id");
            if (createOrgId == 0L || msgSubscriberId == 0L) continue;
            String key = this.appendData(String.valueOf(createOrgId), String.valueOf(msgSubscriberId));
            Set dataValues = dataMap.computeIfAbsent(key, k1 -> new HashSet(16));
            dataValues.add(dataBaseTaskRule);
        }
        return dataMap;
    }

    private String appendData(String ... datas) {
        if (datas == null || datas.length == 0) {
            return "";
        }
        return String.join((CharSequence)"#", datas);
    }
}

