/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.cloudcolla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.ResponseDTO;

public abstract class PayRollActGrpCommonOp
extends AbstractOperationServicePlugIn
implements PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpCommonOp.class);
    public static final String POLICY_ID_LIST = "policyIdList";
    public static final String FIELD_RULE_ID_LIST = "fieldRuleIdList";
    public static final String EXE_PRE_POLICY_ID_LIST = "exePrePolicyIdList";

    public abstract ResponseDTO<Boolean> handlerPolicyData(List<Long> var1, List<Long> var2);

    public abstract ResponseDTO<Boolean> handlerFieldRuleData(List<Long> var1);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("policy");
        e.getFieldKeys().add("frfieldrule");
        e.getFieldKeys().add("frfieldrule.policy.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ResponseDTO<Boolean> policyResponse;
        DynamicObject[] datas = e.getDataEntities();
        if (null == datas || datas.length < 1) {
            return;
        }
        Map<String, List<Long>> allIdMap = PayRollActGrpCommonOp.getAllPolicyIds(datas);
        List<Long> policyIds = allIdMap.get(POLICY_ID_LIST);
        List<Long> exePrePolicyIdList = allIdMap.get(EXE_PRE_POLICY_ID_LIST);
        if (!CollectionUtils.isEmpty(policyIds) && !(policyResponse = this.handlerPolicyData(exePrePolicyIdList, policyIds)).isSuccess()) {
            LOGGER.error("[colla] call PayRollActGrp Op error :{}", (Object)policyResponse.getErrorMsg());
            throw new KDBizException(PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
        }
        List<Long> fieldRuleIds = allIdMap.get(FIELD_RULE_ID_LIST);
        if (!CollectionUtils.isEmpty(fieldRuleIds)) {
            this.handlerFieldRuleData(fieldRuleIds);
        }
    }

    public static Map<String, List<Long>> getAllPolicyIds(DynamicObject[] payRollActGrpObject) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        List exePrePolicyIdList = resultMap.computeIfAbsent(EXE_PRE_POLICY_ID_LIST, item -> new ArrayList(10));
        resultMap.computeIfAbsent(POLICY_ID_LIST, item -> new ArrayList(10));
        resultMap.computeIfAbsent(FIELD_RULE_ID_LIST, item -> new ArrayList(10));
        for (DynamicObject tempPayRollActGrp : payRollActGrpObject) {
            DynamicObjectCollection entryEntity;
            long exePrePolicyId = tempPayRollActGrp.getLong("policy.id");
            if (exePrePolicyId != 0L) {
                exePrePolicyIdList.add(exePrePolicyId);
            }
            if (CollectionUtils.isEmpty((Collection)(entryEntity = tempPayRollActGrp.getDynamicObjectCollection("entryentity")))) continue;
            Map<String, List<Long>> allSubMap = PayRollActGrpCommonOp.getAllSubPolicy(entryEntity);
            ((List)resultMap.get(POLICY_ID_LIST)).addAll((Collection)allSubMap.get(POLICY_ID_LIST));
            ((List)resultMap.get(FIELD_RULE_ID_LIST)).addAll((Collection)allSubMap.get(FIELD_RULE_ID_LIST));
        }
        return resultMap;
    }

    private static Map<String, List<Long>> getAllSubPolicy(DynamicObjectCollection entryEntity) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        List policyIdList = resultMap.computeIfAbsent(POLICY_ID_LIST, item -> new ArrayList(10));
        List fieldRuleIdList = resultMap.computeIfAbsent(FIELD_RULE_ID_LIST, item -> new ArrayList(10));
        for (DynamicObject entry : entryEntity) {
            DynamicObjectCollection fieldRuleEntry = entry.getDynamicObjectCollection("fieldrulesubentryentity");
            if (CollectionUtils.isEmpty((Collection)fieldRuleEntry)) continue;
            for (DynamicObject fieldRuleData : fieldRuleEntry) {
                long policyId;
                long fieldRuleId = fieldRuleData.getLong("frfieldrule.id");
                if (fieldRuleId != 0L) {
                    fieldRuleIdList.add(fieldRuleId);
                }
                if ((policyId = fieldRuleData.getLong("frfieldrule.policy.id")) == 0L) continue;
                policyIdList.add(policyId);
            }
        }
        return resultMap;
    }
}

