/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.cloudcolla;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.ResponseDTO;
import kd.swc.hpdi.opplugin.web.cloudcolla.PayRollActGrpCommonOp;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class PayRollActGrpHisConfirmOp
extends AbstractOperationServicePlugIn
implements PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpCommonOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("policy");
        e.getFieldKeys().add("frpolicy");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ResponseDTO<Boolean> response;
        DynamicObject[] historyDatas = e.getDataEntities();
        List<Long> ids = this.getCurrentPageDynamicObjects(historyDatas);
        if (!CollectionUtils.isEmpty(ids) && !(response = this.handlerPolicyData(ids)).isSuccess()) {
            LOGGER.error("PayRollActGrpHisConfirmOp\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f:{}", (Object)response.getErrorMsg());
            throw new KDBizException(PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
        }
    }

    private List<Long> getCurrentPageDynamicObjects(DynamicObject[] historyDatas) {
        if (historyDatas == null || historyDatas.length < 1) {
            return null;
        }
        ArrayList<Long> payRollActGrpIds = new ArrayList<Long>();
        for (int i = 0; i < historyDatas.length; ++i) {
            DynamicObject hisDatas = historyDatas[i];
            long id = hisDatas.getLong("boid");
            if (id <= 0L) continue;
            payRollActGrpIds.add(id);
        }
        SWCDataServiceHelper payRollActGrpOrm = new SWCDataServiceHelper(historyDatas[0].getDynamicObjectType().getName());
        QFilter idFilter = new QFilter("id", "in", payRollActGrpIds);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] payRollActGrpObjects = payRollActGrpOrm.query("id,name,number,policy", new QFilter[]{idFilter, currentVersionFilter});
        ArrayList<Long> policyIdList = new ArrayList<Long>(10);
        for (DynamicObject payRollActGrpObject : payRollActGrpObjects) {
            long policyId = payRollActGrpObject.getLong("policy.id");
            if (policyId == 0L) continue;
            policyIdList.add(policyId);
        }
        return policyIdList;
    }

    private ResponseDTO<Boolean> handlerPolicyData(List<Long> ids) {
        return PayRollActGrpHelper.disableHrPolicys(ids, null);
    }
}

