/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.cloudcolla.fieldrule;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.swc.hpdi.business.cloudcolla.fieldrule.FieldRuleHelper;

public class FieldRuleSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FieldRuleSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("policy");
        e.getFieldKeys().add("triggercolla.entityobject.number");
        e.getFieldKeys().add("fieldkey");
        e.getFieldKeys().add("fieldname");
        e.getFieldKeys().add("showfieldname");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] fieldRuleDyns = e.getDataEntities();
        if (null == fieldRuleDyns || fieldRuleDyns.length < 1) {
            return;
        }
        Set entityCodes = Arrays.stream(fieldRuleDyns).map(obj -> obj.getString("triggercolla.entityobject.number")).collect(Collectors.toSet());
        HashMap entityFieldMap = Maps.newHashMapWithExpectedSize((int)entityCodes.size());
        for (DynamicObject fieldRuleDyn : fieldRuleDyns) {
            IDataEntityProperty property;
            String entryType = fieldRuleDyn.getString("entrytype");
            if (!StringUtil.equals((String)entryType, (String)"1")) continue;
            String entityCode = fieldRuleDyn.getString("triggercolla.entityobject.number");
            String fieldKey = fieldRuleDyn.getString("fieldkey");
            Map fieldMap = entityFieldMap.computeIfAbsent(entityCode, k -> {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityCode);
                if (entityType == null) {
                    return null;
                }
                return entityType.getAllFields();
            });
            if (CollectionUtils.isEmpty((Map)fieldMap) || (property = (IDataEntityProperty)fieldMap.get(fieldKey)) == null) continue;
            String displayName = property.getDisplayName().toString();
            fieldRuleDyn.set("fieldname", (Object)displayName);
            fieldRuleDyn.set("showfieldname", (Object)displayName);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.deletePolicy();
    }

    private void deletePolicy() {
        Long oldPolicyId = Long.parseLong(this.getOption().getVariableValue("oldPolicyId", "0"));
        if (oldPolicyId == null || oldPolicyId == 0L) {
            return;
        }
        String msg = FieldRuleHelper.deletePolicy((Long)oldPolicyId);
        if (!StringUtils.isEmpty((Object)msg)) {
            log.info("FieldRuleSaveOp deletePolicy msg{}", (Object)msg);
        }
    }
}

