/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.verifybill;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.verify.SumVerifyBillEventBus;
import kd.swc.hpdi.common.entity.CollaResultEntity;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillAuditEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class RelatedVerifyBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(RelatedVerifyBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        super.onPreparePropertys(event);
        List fieldKeys = event.getFieldKeys();
        fieldKeys.add("orgmsgrecvcenter");
        fieldKeys.add("orgmsgrecvcenter.msgcontent");
        fieldKeys.add("org");
        fieldKeys.add("executeseq");
        fieldKeys.add("taskcenter");
        fieldKeys.add("collatask");
        fieldKeys.add("taskrule");
        fieldKeys.add("taskarrange");
        fieldKeys.add("taskarrangev");
        fieldKeys.add("taskarrangeclass");
        fieldKeys.add("taskrule.sourcevid");
        fieldKeys.add("taskrule.immediately");
        fieldKeys.add("taskrule.createorg");
        fieldKeys.add("taskrule.ismanualverify");
        fieldKeys.add("taskrulev");
        fieldKeys.add("taskrulev.sourcevid");
        fieldKeys.add("taskrulev.immediately");
        fieldKeys.add("taskrulev.ismanualverify");
        fieldKeys.add("taskrulev.createorg");
        fieldKeys.add("dutyworkrole");
        fieldKeys.add("changetime");
        fieldKeys.add("orgteam");
        fieldKeys.add("flowtype");
        fieldKeys.add("payrollactgv.id");
        fieldKeys.add("payrollactgv.boid");
        fieldKeys.add("auditdate");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("collarulevclass");
        fieldKeys.add("collarulev");
        fieldKeys.add("collarulev.boid");
        fieldKeys.add("employee");
        fieldKeys.add("person");
        fieldKeys.add("depemp");
        fieldKeys.add("cmpemp");
        fieldKeys.add("verifyapp");
        fieldKeys.add("multaskcenter");
        fieldKeys.add("mulcollatask");
        fieldKeys.add("collataskclass");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs event) {
        super.beforeExecuteOperationTransaction(event);
        DynamicObject[] dataList = event.getDataEntities();
        Date auditDate = new Date();
        for (DynamicObject object : dataList) {
            object.set("billstatus", (Object)"C");
            object.set("auditstatus", (Object)"C");
            object.set("auditdate", (Object)auditDate);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        super.beginOperationTransaction(event);
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        super.onAddValidators(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs event) {
        super.afterExecuteOperationTransaction(event);
        DynamicObject[] dataEntities = event.getDataEntities();
        this.autoExecuteExistTask(dataEntities);
        CollaResultEntity collaTaskFromVerifyBill = CollaMsgVerifyBillHelper.getInstance().createCollaTaskFromVerifyBill(dataEntities);
        if (!collaTaskFromVerifyBill.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u85aa\u916c\u6838\u5b9a\u5355\u5ba1\u6838\u8fc7\u7a0b\u4e2d\uff0c\u521b\u5efa\u534f\u4f5c\u4efb\u52a1\u5931\u8d25\u3002\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SummaryVerifyBillAuditOp_0", (String)"swc-hpdi-opplugin", (Object[])new Object[0]));
        }
        try (TXHandle txHandle = TX.requiresNew();){
            HashMap<String, DynamicObject[]> param = new HashMap<String, DynamicObject[]>(16);
            param.put("summaryBills", dataEntities);
            BillAuditEvent billAuditEvent = new BillAuditEvent(param);
            SumVerifyBillEventBus.getInstance().post((AbstractVerifyBillEvent)billAuditEvent);
            if (!billAuditEvent.isSuccess()) {
                throw new KDBizException(CollaMsgVerifyBillHelper.getInstance().getErrorTips());
            }
            txHandle.commit();
        }
    }

    private void autoExecuteExistTask(DynamicObject[] dataEntities) {
        HashMap<String, Set> taskCenter = new HashMap<String, Set>(16);
        DynamicObject[] dynamicObjectArray = dataEntities;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dataEntity;
            String ctClass = (dataEntity = dynamicObjectArray[i]).getString("collataskclass");
            DynamicObjectCollection collaTaskList = dataEntity.getDynamicObjectCollection("hpdi_collatask".equalsIgnoreCase(ctClass) ? "mulcollatask" : "multaskcenter");
            if (CollectionUtils.isEmpty((Collection)collaTaskList)) continue;
            Set ids = taskCenter.computeIfAbsent(ctClass, item -> new HashSet(16));
            ids.addAll(collaTaskList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        }
        taskCenter.forEach(this::invokeExecuteTaskOp);
    }

    private void invokeExecuteTaskOp(String ctClass, Set<Long> ids) {
        if (SWCStringUtils.isEmpty((String)ctClass) || CollectionUtils.isEmpty(ids)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(ctClass);
        DynamicObject[] query = helper.query(SWCHisBaseDataHelper.getSelectProperties((String)ctClass), new QFilter[]{new QFilter("id", "in", ids)});
        OperateOption option = OperateOption.create();
        this.operateOption.setVariableValue("taskexecmanner", "auto");
        this.operateOption.setVariableValue("ishasright", "true");
        this.operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
        OperationServiceHelper.executeOperate((String)"executetask", (String)ctClass, (DynamicObject[])query, (OperateOption)option);
    }
}

