/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.verifybill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.verify.SumVerifyBillEventBus;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillSaveEvent;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class RelatedVerifyBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs event) {
        super.onPreparePropertys(event);
        List fieldKeys = event.getFieldKeys();
        fieldKeys.addAll(SWCHisBaseDataHelper.getFields((MainEntityType)this.billEntityType));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs event) {
        DynamicObject[] eventDataEntities;
        super.beforeExecuteOperationTransaction(event);
        for (DynamicObject eventDataEntity : eventDataEntities = event.getDataEntities()) {
            eventDataEntity.set("relbillid", (Object)eventDataEntity.getLong("id"));
            String taskArrangeClass = eventDataEntity.getString("taskarrangeclass");
            Object taskArrange = eventDataEntity.get("taskarrange");
            if ("hpdi_taskrule".equalsIgnoreCase(taskArrangeClass)) {
                eventDataEntity.set("taskrule", taskArrange);
            } else {
                eventDataEntity.set("taskrulen", taskArrange);
            }
            String collaTaskClass = eventDataEntity.getString("collataskclass");
            if (SWCStringUtils.isEmpty((String)collaTaskClass)) {
                collaTaskClass = HPDICloudCollaHelper.getInstance().matchCollaTaskNumber(taskArrangeClass);
                eventDataEntity.set("collataskclass", (Object)collaTaskClass);
            }
            Object collaTask = eventDataEntity.get("collatask");
            if ("hpdi_taskcenter".equalsIgnoreCase(collaTaskClass)) {
                eventDataEntity.set("taskcenter", collaTask);
                continue;
            }
            eventDataEntity.set("taskcentern", collaTask);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        super.beginOperationTransaction(event);
    }

    public void endOperationTransaction(EndOperationTransactionArgs event) {
        Map ruleEngineResults;
        super.endOperationTransaction(event);
        if (this.isStop()) {
            return;
        }
        DynamicObject[] entities = event.getDataEntities();
        OperateOption option = this.getOption();
        RefObject refObject = new RefObject();
        Map billFieldValues = null;
        if (option.tryGetVariableValue("billFieldValues", refObject)) {
            billFieldValues = (Map)SerializationUtils.deSerializeFromBase64((String)((String)refObject.getValue()));
        }
        if (CollectionUtils.isEmpty(billFieldValues) && option.tryGetVariableValue("ruleEngineResults", refObject) && !CollectionUtils.isEmpty((Map)(ruleEngineResults = (Map)SerializationUtils.deSerializeFromBase64((String)((String)refObject.getValue()))))) {
            billFieldValues = CollaMsgVerifyBillHelper.getInstance().getBillFieldValues(ruleEngineResults);
        }
        RefObject formObject = new RefObject();
        String notSaveBillFromIds = "";
        if (option.tryGetVariableValue("notSaveBillFromIds", formObject)) {
            notSaveBillFromIds = (String)formObject.getValue();
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("summaryVerifyBill", entities);
        param.put("billFieldValues", billFieldValues);
        param.put("notSaveBillFromIds", notSaveBillFromIds);
        BillSaveEvent billSaveEvent = new BillSaveEvent(param);
        SumVerifyBillEventBus.getInstance().post((AbstractVerifyBillEvent)billSaveEvent);
        if (!billSaveEvent.isSuccess()) {
            throw new KDBizException(CollaMsgVerifyBillHelper.getInstance().getErrorTips());
        }
    }

    private boolean isStop() {
        OperateOption option = this.getOption();
        RefObject refObject = new RefObject();
        option.tryGetVariableValue("bill_option_form", refObject);
        String value = (String)refObject.getValue();
        return "list".equalsIgnoreCase(value);
    }
}

