/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.verifybill;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.verify.SumVerifyBillEventBus;
import kd.swc.hpdi.opplugin.validator.verify.SummaryVerifyBillDiscardValidator;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillDiscardEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SummaryVerifyBillDiscardOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SummaryVerifyBillDiscardOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("orgmsgrecvcenter");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("taskcenter");
        fieldKeys.add("taskcenter.enable");
        fieldKeys.add("collatask");
        fieldKeys.add("multaskcenter");
        fieldKeys.add("mulcollatask");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new SummaryVerifyBillDiscardValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] data = args.getDataEntities();
        this.updateMsgRecvStatus(data);
        this.relatedDiscardBills(data);
    }

    private void relatedDiscardBills(DynamicObject[] data) {
        HashMap<String, DynamicObject[]> param = new HashMap<String, DynamicObject[]>(16);
        param.put("summaryBills", data);
        BillDiscardEvent billDiscardEvent = new BillDiscardEvent(param);
        SumVerifyBillEventBus.getInstance().post((AbstractVerifyBillEvent)billDiscardEvent);
        if (!billDiscardEvent.isSuccess()) {
            throw new KDBizException(CollaMsgVerifyBillHelper.getInstance().getErrorTips());
        }
    }

    private void updateMsgRecvStatus(DynamicObject[] data) {
        HashSet<Long> allRecvIdSet = new HashSet<Long>(data.length);
        HashSet<Long> idSet = new HashSet<Long>(data.length);
        String ctClass = "";
        for (DynamicObject datum : data) {
            long id;
            long recId;
            if (SWCStringUtils.isEmpty((String)ctClass)) {
                ctClass = datum.getString("collataskclass");
            }
            if ((recId = datum.getLong("orgmsgrecvcenter.id")) != 0L) {
                allRecvIdSet.add(recId);
            }
            if ((id = datum.getLong("id")) == 0L) continue;
            idSet.add(recId);
        }
        allRecvIdSet.removeAll(this.getNeedRemoveIdFromBill(allRecvIdSet, idSet));
        allRecvIdSet.removeAll(this.getNeedRemoveIdFromTask(ctClass, allRecvIdSet));
        if (CollectionUtils.isEmpty(allRecvIdSet)) {
            return;
        }
        SWCDataServiceHelper recOrm = new SWCDataServiceHelper("hpdi_msgreceive");
        DynamicObject[] query = recOrm.query("id,taskcreatestatus", new QFilter[]{new QFilter("id", "in", allRecvIdSet)});
        if (query == null || query.length == 0) {
            return;
        }
        for (DynamicObject object : query) {
            object.set("taskcreatestatus", (Object)"A");
        }
        recOrm.save(query);
    }

    private Set<Long> getNeedRemoveIdFromTask(String ctClass, Set<Long> receiveMsgIdSet) {
        if (SWCStringUtils.isEmpty((String)ctClass)) {
            return Collections.emptySet();
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(ctClass);
        DynamicObject[] query = helper.queryOriginalArray("id,orgmsgrecvcenter.id", new QFilter[]{new QFilter("orgmsgrecvcenter.id", "in", receiveMsgIdSet), new QFilter("enable", "in", (Object)"1")});
        if (query == null || query.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.stream(query).map(item -> item.getLong("orgmsgrecvcenter.id")).collect(Collectors.toSet());
    }

    private Set<Long> getNeedRemoveIdFromBill(Set<Long> receiveMsgIdSet, Set<Long> idSet) {
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hpdi_summaryvbill");
        DynamicObject[] ids = orm.queryOriginalArray("id,orgmsgrecvcenter.id", new QFilter[]{new QFilter("orgmsgrecvcenter.id", "in", receiveMsgIdSet), new QFilter("id", "not in", idSet), new QFilter("billstatus", "not in", Arrays.asList("F", "E"))});
        HashSet<Long> notInRecIdSet = new HashSet<Long>(ids.length);
        for (DynamicObject obj : ids) {
            notInRecIdSet.add(obj.getLong("orgmsgrecvcenter.id"));
        }
        return notInRecIdSet;
    }
}

