/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.opplugin.web.verifybill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SummaryVerifyBillSscDiscardOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SummaryVerifyBillSscDiscardOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        if ("discard".equals(args.getOperationKey())) {
            SWCThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> this.discardData(args.getDataEntities()));
        }
    }

    private void discardData(DynamicObject[] dataList) {
        try {
            ArrayList assignIdsList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList list = Lists.newArrayListWithExpectedSize((int)11);
            for (DynamicObject data : dataList) {
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                paramMap.put("billId", data.getLong("id"));
                assignIdsList.add(data.getString("id"));
                paramMap.put("entityNumber", data.getDynamicObjectType().getName());
                list.add(paramMap);
            }
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("list", list);
            logger.info("ITaskService#taskQueryByBillId list:{}", (Object)list);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskQueryByBillId", (Object[])new Object[]{paramMap});
            logger.info("ITaskService#taskQueryByBillId result:{}", (Object)result);
            long currUserId = RequestContext.get().getCurrUserId();
            if (ObjectUtils.isNotEmpty((Object)result) && result.get("success").equals("true")) {
                ArrayList terminateList = Lists.newArrayListWithExpectedSize((int)11);
                ArrayList deleteList = Lists.newArrayListWithExpectedSize((int)11);
                Map data = (Map)result.get("data");
                if (ObjectUtils.isNotEmpty((Object)data)) {
                    List billTaskMapList = (List)data.get("billTaskMapList");
                    if (SWCListUtils.isEmpty((List)billTaskMapList)) {
                        return;
                    }
                    for (Map billTaskMap : billTaskMapList) {
                        List taskList = (List)billTaskMap.get("taskList");
                        if (CollectionUtils.isEmpty((Collection)taskList)) continue;
                        Map task = (Map)taskList.get(0);
                        Object state = task.get("state");
                        Object taskId = task.get("taskId");
                        Object personId = task.get("personId");
                        if (state.equals("12")) {
                            HashMap deleteParamMap = Maps.newHashMapWithExpectedSize((int)16);
                            deleteParamMap.put("taskId", taskId);
                            deleteParamMap.put("currentPersonId", currUserId);
                            deleteList.add(deleteParamMap);
                            continue;
                        }
                        HashMap terminateParamMap = Maps.newHashMapWithExpectedSize((int)16);
                        terminateParamMap.put("taskId", taskId);
                        terminateParamMap.put("currentPersonId", currUserId);
                        terminateParamMap.put("operatorId", personId);
                        terminateList.add(terminateParamMap);
                    }
                }
                logger.info("ITaskService#taskQueryByBillId terminateList:{},deleteList", (Object)terminateList, (Object)deleteList);
                if (terminateList.size() > 0) {
                    HashMap terminateParamMap = Maps.newHashMapWithExpectedSize((int)16);
                    terminateParamMap.put("list", terminateList);
                    Map terminateMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskApproveByTerminate", (Object[])new Object[]{terminateParamMap});
                    logger.info("ITaskService#taskQueryByBillId terminateMap:{}", (Object)terminateMap);
                }
                if (deleteList.size() > 0) {
                    HashMap deleteParamMap = Maps.newHashMapWithExpectedSize((int)16);
                    deleteParamMap.put("list", deleteList);
                    Map deleteMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskDeleteByTaskId", (Object[])new Object[]{deleteParamMap});
                    logger.info("ITaskService#taskQueryByBillId deleteMap:{}", (Object)deleteMap);
                }
                for (String assignIds : assignIdsList) {
                    if (!WorkflowServiceHelper.inProcess((String)assignIds)) continue;
                    WorkflowServiceHelper.abandonByBusienssKey((String)assignIds);
                }
            }
        }
        catch (Exception exception) {
            logger.error("afterExecuteOperationTransaction exception\uff1a{}", (Object)exception.getMessage());
        }
    }
}

