/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DynamicEntryDataPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject args) {
        Object entryDataObj = this.getView().getFormShowParameter().getCustomParam("entryData");
        if (null == entryDataObj) {
            return;
        }
        List entryData = SerializationUtils.fromJsonStringToList((String)((String)entryDataObj), Map.class);
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryType = collection.getDynamicObjectType();
        Map<String, IDataEntityProperty> propMap = entryType.getProperties().stream().collect(Collectors.toMap(prop -> prop.getName(), prop -> prop, (k1, k2) -> k1));
        Set<String> entryEntityFields = propMap.keySet();
        for (Map rowData : entryData) {
            DynamicObject row = (DynamicObject)entryType.createInstance();
            Map data = (Map)rowData.get("data");
            for (Map.Entry entry : data.entrySet()) {
                String key = ((String)entry.getKey()).toLowerCase();
                if (!entryEntityFields.contains(key)) continue;
                Object value = entry.getValue();
                if (null == value || SWCStringUtils.isEmpty((String)String.valueOf(value))) {
                    row.set(key, value);
                    continue;
                }
                String className = propMap.get(key).getPropertyType().getName();
                if ("java.util.Date".equals(className)) {
                    try {
                        value = SWCDateTimeUtils.parseDate((String)String.valueOf(value));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                } else if ("kd.bos.dataentity.entity.DynamicObject".equals(className)) {
                    String baseEntityId = ((BasedataProp)propMap.get(key)).getBaseEntityId();
                    value = BusinessDataServiceHelper.loadSingle(value, (String)baseEntityId);
                }
                row.set(key, value);
            }
            collection.add((Object)row);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setEntryGridStyle();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
    }

    private void setEntryGridStyle() {
        Object entryDataObj = this.getView().getFormShowParameter().getCustomParam("entryData");
        if (null == entryDataObj) {
            return;
        }
        List entryData = SerializationUtils.fromJsonStringToList((String)((String)entryDataObj), Map.class);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(10);
        for (int i = 0; i < entryData.size(); ++i) {
            Map row = (Map)entryData.get(i);
            Map renderColor = (Map)row.get("renderColor");
            if (null == renderColor || renderColor.isEmpty()) continue;
            for (Map.Entry entry : renderColor.entrySet()) {
                CellStyle cs = new CellStyle();
                cs.setForeColor((String)entry.getValue());
                cs.setFieldKey(((String)entry.getKey()).toLowerCase());
                cs.setRow(i);
                csList.add(cs);
            }
        }
        grid.setCellStyle(csList);
        grid.setSplitPage(false);
    }
}

