/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.xdb.util.Pair;
import kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper;
import kd.swc.hsbp.business.dynamicentry.SWCDynamicEntryGrid;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.FieldParamContainer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DynamicEntryEdit
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY_PARENT = "flexpanelap";
    private static final String FIELD_PARAMS = "fieldParamMaps";
    private static Map<String, String> DATA_TYPE_MAP = new HashMap<String, String>(16);

    public void initialize() {
        this.rewriteEntryGrid();
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map params = ((FormShowParameter)args.getSource()).getCustomParams();
        List<EntryParamContainer> entryApBuildParam = this.createEntryBuildParamForTabular(params);
        EntryAp entryAp = EntryParamContainerBaseHelper.createControlAp(entryApBuildParam);
        entryAp.setShowSeq(true);
        entryAp.setOrderAndFilter(0);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            return;
        }
        List<EntryParamContainer> entryApBuildParam = this.createEntryBuildParamForTabular(this.getView().getFormShowParameter().getCustomParams());
        EntryParamContainerBaseHelper.registProp(entryApBuildParam, (EntityType)((EntityType)newMainType.getAllEntities().get("entryentity")));
        args.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Control oldGrid = this.getView().getControl("entryentity");
        EntryGrid entryGrid = this.rewriteEntryGridControl(oldGrid);
        this.setEntryGridControlIndex(entryGrid, this.getView());
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isEmpty((Map)params) || !params.containsKey(FIELD_PARAMS)) {
            return;
        }
        List fieldParamMaps = SerializationUtils.fromJsonStringToList((String)((String)params.get(FIELD_PARAMS)), Map.class);
        if (CollectionUtils.isEmpty((Collection)fieldParamMaps)) {
            return;
        }
        List fixedFields = fieldParamMaps.stream().filter(param -> "1".equals(MapUtils.getString((Map)param, (Object)"isFixed"))).map(param -> MapUtils.getString((Map)param, (Object)"key").toLowerCase()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(fixedFields)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            for (String key : fixedFields) {
                entryGrid.setColumnProperty(key, "isFixed", (Object)Boolean.TRUE);
            }
        }
    }

    private void rewriteEntryGrid() {
        this.rewriteEntryGridControl();
        this.createDynamicEntryColumn();
    }

    private void createDynamicEntryColumn() {
        Control rootControl = this.getView().getRootControl();
        EntryGrid oldGrid = (EntryGrid)BizDataBillEntryGridHelper.findControl(Collections.singletonList(rootControl), (String)"entryentity");
        List<EntryParamContainer> entryApBuildParam = this.createEntryBuildParamForTabular(this.getView().getFormShowParameter().getCustomParams());
        EntryAp entryAp2 = EntryParamContainerBaseHelper.createControlAp(entryApBuildParam);
        oldGrid.getItems().clear();
        oldGrid.getItems().addAll(((Container)entryAp2.buildRuntimeControl()).getItems());
        BizDataBillEntryGridHelper.setControlView((List)oldGrid.getItems(), (IFormView)this.getView());
        oldGrid.endInit();
    }

    private void rewriteEntryGridControl() {
        Container container = (Container)this.getControl(KEY_ENTRYENTITY_PARENT);
        List<EntryParamContainer> createEntryBuildParam = this.createEntryBuildParamForTabular(this.getView().getFormShowParameter().getCustomParams());
        EntryAp entryAp = EntryParamContainerBaseHelper.createControlAp(createEntryBuildParam);
        entryAp.setShowSeq(true);
        entryAp.setOrderAndFilter(1);
        SWCDynamicEntryGrid grid = new SWCDynamicEntryGrid();
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        grid.setSplitPage(true);
        grid.getItems().clear();
        grid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
        BizDataBillEntryGridHelper.setControlView((List)grid.getItems(), (IFormView)this.getView());
        grid.setView(this.getView());
        grid.endInit();
        grid.endInit();
        int index = BizDataBillEntryGridHelper.findControlIndex((List)container.getItems(), (String)"entryentity");
        if (index >= 0) {
            container.getItems().add(index, grid);
        }
        this.getView().createControlIndex(Collections.singletonList(grid));
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        grid.initGridConfig((Map)map);
    }

    private List<EntryParamContainer> createEntryBuildParamForTabular(Map<String, Object> params) {
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hpdi_dynamicentry", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        this.addFieldContainer(allContainer, entityMetadata, params);
        return allContainer;
    }

    private EntryGrid rewriteEntryGridControl(Control oldGrid) {
        SWCDynamicEntryGrid entryGrid = new SWCDynamicEntryGrid();
        entryGrid.setView(this.getView());
        entryGrid.setKey("entryentity");
        entryGrid.setEntryKey("entryentity");
        entryGrid.setSplitPage(true);
        if (oldGrid == null) {
            this.findControl("entryentity");
        }
        if (oldGrid instanceof EntryGrid) {
            entryGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
        }
        return entryGrid;
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return BizDataBillEntryGridHelper.findControl((List)root.getItems(), (String)key);
    }

    private void setEntryGridControlIndex(EntryGrid entryGrid, IFormView formView) {
        Container flexPanelAp = (Container)this.findControl(KEY_ENTRYENTITY_PARENT);
        if (flexPanelAp == null) {
            return;
        }
        List items = flexPanelAp.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Control item = (Control)items.get(i);
            if (!"entryentity".equals(item.getKey())) continue;
            flexPanelAp.getItems().set(i, entryGrid);
        }
        formView.createControlIndex(flexPanelAp.getItems());
    }

    private void addFieldContainer(List<EntryParamContainer> allContainer, EntityMetadata entityMetadata, Map<String, Object> params) {
        if (MapUtils.isEmpty(params) || !params.containsKey(FIELD_PARAMS)) {
            return;
        }
        List fieldParamMaps = SerializationUtils.fromJsonStringToList((String)((String)params.get(FIELD_PARAMS)), Map.class);
        if (CollectionUtils.isEmpty((Collection)fieldParamMaps)) {
            return;
        }
        for (Map itemMap : fieldParamMaps) {
            Object pairs;
            itemMap.put("key", MapUtils.getString((Map)itemMap, (Object)"key").toLowerCase());
            String dataType = DATA_TYPE_MAP.getOrDefault(String.valueOf(itemMap.get("dataType")), "1030_S");
            if (!itemMap.containsKey("lock")) {
                itemMap.put("lock", "new,edit,view,submit,audit");
            }
            if ("COMBO".equals(dataType) && null != (pairs = itemMap.get("pairs")) && pairs instanceof ArrayList) {
                ArrayList<Pair> pairList = new ArrayList<Pair>(10);
                for (Map pairMap : (ArrayList)pairs) {
                    Pair pair = new Pair(pairMap.get("key"), pairMap.get("value"));
                    pairList.add(pair);
                }
                itemMap.put("pairs", pairList.toArray(new Pair[0]));
            }
            FieldParamContainer itemContainer = BizDataBillEntryGridHelper.createContainer((String)dataType, (EntityMetadata)entityMetadata, (Map)itemMap);
            if ("1".equals(itemMap.get("isHyperLink"))) {
                itemContainer.setHyperlink(true);
            }
            if ("1".equals(itemMap.get("isHidden"))) {
                itemContainer.setHidden(true);
            }
            allContainer.add((EntryParamContainer)itemContainer);
        }
    }

    static {
        DATA_TYPE_MAP.put("TEXT", "1030_S");
        DATA_TYPE_MAP.put("DATETIME", "1050_S");
        DATA_TYPE_MAP.put("NUMBER", "1010_S");
        DATA_TYPE_MAP.put("AMOUNT", "1020_S");
        DATA_TYPE_MAP.put("COMBO", "COMBO");
        DATA_TYPE_MAP.put("BASEDATA", "BASEDATA");
        DATA_TYPE_MAP.put("BOOLEAN", "BOOLEAN");
    }
}

