/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class PdiPayRollActGrpEdit
extends AbstractFormPlugin {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject payRollActGTplDyobj = this.getModel().getDataEntity().getDynamicObject("payrollactgtpl");
        if (null != payRollActGTplDyobj) {
            this.reloadPayRollActGTplData(payRollActGTplDyobj);
        }
    }

    private void reloadPayRollActGTplData(DynamicObject payRollActGTplDyobj) {
        IDataModel model = this.getModel();
        DynamicObjectCollection tplEntryentities = payRollActGTplDyobj.getDynamicObjectCollection("entryentity");
        Map<String, Boolean> payRollActIsPresetMap = this.getPayRollActIsSysPreSetProp(tplEntryentities);
        model.beginInit();
        int size = this.getModel().getEntryEntity("entryentity").size();
        for (int i = 0; i < size; ++i) {
            DynamicObject tplEntryentity = (DynamicObject)tplEntryentities.get(i);
            model.setValue("ismustexecute", tplEntryentity.get("ismustexecute"), i);
            String payRollActId = tplEntryentity.getString("payrollact.id");
            Boolean isPayRollActPreset = payRollActIsPresetMap.get(payRollActId);
            if (null == isPayRollActPreset || !isPayRollActPreset.booleanValue()) continue;
            model.setValue("ispayrollactsyspreset", (Object)"1", i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.setIsExecuteEnable(tplEntryentities);
    }

    private void setIsExecuteEnable(DynamicObjectCollection tplEntryentities) {
        int size = tplEntryentities.size();
        for (int i = 0; i < size; ++i) {
            if (((DynamicObject)tplEntryentities.get(i)).getBoolean("ismustexecute")) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isexecute"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"isexecute"});
        }
    }

    private Map<String, Boolean> getPayRollActIsSysPreSetProp(DynamicObjectCollection tplEntryentities) {
        List payRollActIds = tplEntryentities.stream().map(tplEntryentity -> tplEntryentity.getLong("payrollact.id")).collect(Collectors.toList());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hpdi_payrollact");
        QFilter qFilter = new QFilter("id", "in", payRollActIds);
        DynamicObject[] payRollActDyobjs = serviceHelper.query("issyspreset", new QFilter[]{qFilter});
        HashMap<String, Boolean> payRollActIsPresetMap = new HashMap<String, Boolean>(16);
        for (DynamicObject payRollActDyobj : payRollActDyobjs) {
            payRollActIsPresetMap.put(payRollActDyobj.getString("id"), payRollActDyobj.getBoolean("issyspreset"));
        }
        return payRollActIsPresetMap;
    }
}

